/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator;

import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TestInputGroup {
    private final Object identifier;
    private final List<int[]> testInputs;
    private final FaultCharacterizationConfiguration faultCharacterizationConfiguration;

    public TestInputGroup(Object identifier, Collection<int[]> testInputs) {
        this(identifier, testInputs, null);
    }

    public TestInputGroup(Object identifier, Collection<int[]> testInputs, FaultCharacterizationConfiguration faultCharacterizationConfiguration) {
        this.identifier = Preconditions.notNull(identifier);
        this.testInputs = new ArrayList<int[]>(Preconditions.notNull(testInputs));
        this.faultCharacterizationConfiguration = faultCharacterizationConfiguration;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public List<int[]> getTestInputs() {
        return Collections.unmodifiableList(this.testInputs);
    }

    public Optional<FaultCharacterizationConfiguration> getFaultCharacterizationConfiguration() {
        return Optional.ofNullable(this.faultCharacterizationConfiguration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestInputGroup that = (TestInputGroup)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return "TestInputGroup{identifier=" + this.identifier + ", testInputs=" + this.testInputs + ", faultCharacterizationConfiguration=" + this.faultCharacterizationConfiguration + "}";
    }
}

