/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg;

import de.rwth.swc.coffee4j.algorithmic.constraint.DynamicHardConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.GroupSpecificTestModel;
import de.rwth.swc.coffee4j.algorithmic.report.Reporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroup;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.AetgSatAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.AetgSatConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class AetgSat
implements TestInputGroupGenerator {
    private static final String DISPLAY_NAME = "Positive AetgSatAlgorithm Tests";

    public Set<Supplier<TestInputGroup>> generate(CompleteTestModel model, Reporter reporter) {
        if (model.getPositiveTestingStrength() == 0) {
            return Collections.emptySet();
        }
        return Collections.singleton(() -> {
            DynamicHardConstraintChecker constraintChecker = new DynamicHardConstraintChecker(model, model.getExclusionConstraints(), model.getErrorConstraints());
            GroupSpecificTestModel groupModel = GroupSpecificTestModel.positive(model, constraintChecker);
            List<int[]> testInputs = new AetgSatAlgorithm(AetgSatConfiguration.aetgSatConfiguration().model(groupModel).build()).generate();
            FaultCharacterizationConfiguration faultCharacterizationConfiguration = new FaultCharacterizationConfiguration(groupModel, reporter);
            return new TestInputGroup(DISPLAY_NAME, testInputs, faultCharacterizationConfiguration);
        });
    }
}

