/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg;

import de.rwth.swc.coffee4j.algorithmic.constraint.DynamicHardConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.AetgSatConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class AetgSatAlgorithm {
    private final AetgSatConfiguration configuration;
    private final TestModel model;
    private final CoverageMap coverageMap;
    private final DynamicHardConstraintChecker checker;
    private final IntList parameterIndices;
    private final int totalValues;
    private final Random random = ThreadLocalRandom.current();

    public AetgSatAlgorithm(AetgSatConfiguration configuration) {
        Preconditions.notNull(configuration, "configuration required");
        Preconditions.check(configuration.getModel().getConstraintChecker() instanceof DynamicHardConstraintChecker, "Can only use DynamicHardConstraintChecker with AETG");
        this.configuration = Preconditions.notNull(configuration);
        this.model = configuration.getModel();
        this.checker = (DynamicHardConstraintChecker)this.model.getConstraintChecker();
        this.coverageMap = new CoverageMap(this.model.getParameterSizes(), this.model.getDefaultTestingStrength(), this.checker);
        this.parameterIndices = new IntArrayList();
        for (int i = 0; i < this.model.getNumberOfParameters(); ++i) {
            this.parameterIndices.add(i);
        }
        this.totalValues = Arrays.stream(this.model.getParameterSizes()).reduce(Integer::sum).orElse(0);
    }

    private Optional<int[]> getTestCaseWithFixedValues(int[] fixedValues, Set<ParameterValuePair> forbidden) {
        int[] testCase = Arrays.copyOf(fixedValues, fixedValues.length);
        boolean sat = false;
        HashSet<ParameterValuePair> forbiddenPairs = new HashSet<ParameterValuePair>(forbidden);
        ParameterValuePair first = null;
        IntArraySet forbiddenParameters = new IntArraySet(fixedValues.length);
        for (int i = 0; i < fixedValues.length; ++i) {
            if (fixedValues[i] == -1) continue;
            forbiddenParameters.add(i);
        }
        while (!sat) {
            if (forbidden.size() >= this.totalValues) {
                return Optional.empty();
            }
            first = this.selectFirstFactorValue(forbiddenPairs, (IntSet)forbiddenParameters);
            sat = this.checkTestCase(testCase, first);
            if (sat) continue;
            forbiddenPairs.add(first);
        }
        testCase[first.getParameter()] = first.getValue();
        Collections.shuffle(this.parameterIndices, this.random);
        IntListIterator intListIterator = this.parameterIndices.iterator();
        while (intListIterator.hasNext()) {
            int parameter = (Integer)intListIterator.next();
            if (testCase[parameter] != -1) continue;
            sat = false;
            int tries = 0;
            int maxTries = this.configuration.getMaximumNumberOfTries();
            IntArraySet forbiddenValues = new IntArraySet();
            Optional<Object> best = Optional.empty();
            while (!sat && tries < maxTries && (best = this.selectBestValue(parameter, (IntSet)forbiddenValues, testCase)).isPresent()) {
                sat = this.checkTestCase(testCase, (ParameterValuePair)best.get());
                if (sat) continue;
                forbiddenValues.add(((ParameterValuePair)best.get()).getValue());
            }
            if (!sat) {
                return Optional.empty();
            }
            testCase[((ParameterValuePair)best.get()).getParameter()] = ((ParameterValuePair)best.get()).getValue();
        }
        return Optional.of(testCase);
    }

    public Optional<int[]> getMutatedTestCase(int parameter, int[] testCase, List<int[]> lastMutations) {
        int[] result = Arrays.copyOf(testCase, testCase.length);
        boolean sat = false;
        IntArraySet forbiddenValues = new IntArraySet();
        forbiddenValues.add(testCase[parameter]);
        lastMutations.forEach(arg_0 -> AetgSatAlgorithm.lambda$getMutatedTestCase$0((IntSet)forbiddenValues, parameter, arg_0));
        Optional<Object> best = Optional.empty();
        for (int tries = 0; !sat && tries < this.configuration.getMaximumNumberOfTries(); ++tries) {
            best = this.selectBestValue(parameter, (IntSet)forbiddenValues, testCase);
            if (!best.isPresent()) {
                sat = false;
                break;
            }
            sat = this.checkTestCase(testCase, (ParameterValuePair)best.get());
            if (sat) continue;
            forbiddenValues.add(((ParameterValuePair)best.get()).getValue());
        }
        if (!sat) {
            return Optional.empty();
        }
        result[((ParameterValuePair)best.get()).getParameter()] = ((ParameterValuePair)best.get()).getValue();
        return Optional.of(result);
    }

    public Optional<int[]> getNextTestCase() {
        if (!this.coverageMap.hasUncoveredCombinations()) {
            return Optional.empty();
        }
        ArrayList candidates = new ArrayList();
        for (int candidateCount = 0; candidateCount < this.configuration.getNumberOfCandidates(); ++candidateCount) {
            Optional<int[]> testCase = this.getTestCaseWithFixedValues(CombinationUtil.emptyCombination(this.model.getNumberOfParameters()), new HashSet<ParameterValuePair>());
            testCase.ifPresent(candidates::add);
        }
        if (!candidates.isEmpty()) {
            return Optional.of(Collections.max(candidates, Comparator.comparing(this.coverageMap::getNumberOfUncoveredCombinations)));
        }
        return Optional.empty();
    }

    private Optional<ParameterValuePair> selectBestValue(int parameter, IntSet forbiddenValues, int[] testCase) {
        int[] candidate = Arrays.copyOf(testCase, testCase.length);
        int bestValue = -1;
        long bestValueResult = -1L;
        for (int value = 0; value < this.model.getParameterSize(parameter); ++value) {
            if (forbiddenValues.contains(value)) continue;
            candidate[parameter] = value;
            long valueResult = this.coverageMap.getNumberOfUncoveredCombinations(candidate);
            if (valueResult <= bestValueResult) continue;
            bestValueResult = valueResult;
            bestValue = value;
        }
        if (bestValue == -1) {
            return Optional.empty();
        }
        return Optional.of(new ParameterValuePair(parameter, bestValue));
    }

    private boolean checkTestCase(int[] testCase, ParameterValuePair pv) {
        if (this.checker.getInvolvedParameters().contains(pv.getParameter())) {
            int[] candidate = Arrays.copyOf(testCase, testCase.length);
            candidate[pv.getParameter()] = pv.getValue();
            return this.checker.isValid(candidate);
        }
        return true;
    }

    private ParameterValuePair selectFirstFactorValue(Set<ParameterValuePair> forbiddenPairs, IntSet forbiddenParameters) {
        return this.coverageMap.getMostCommonValue(forbiddenPairs, forbiddenParameters);
    }

    public List<int[]> generate() {
        ArrayList<int[]> result = new ArrayList<int[]>();
        Optional<int[]> nextTestCase = this.getNextTestCase();
        while (nextTestCase.isPresent()) {
            this.updateCoverage(nextTestCase.get());
            result.add(nextTestCase.get());
            nextTestCase = this.getNextTestCase();
        }
        return result;
    }

    public void updateCoverage(int[] testCase) {
        this.coverageMap.updateSubCombinationCoverage(testCase);
    }

    public void addForbiddenCombination(int[] combination) {
        this.coverageMap.addForbiddenCombination(combination);
    }

    public int[] selectDissimilar(int[] failureInducingCombination, int[] failure, List<int[]> lastFeedback) {
        int[] result = Arrays.copyOf(failureInducingCombination, failureInducingCombination.length);
        for (int parameter = 0; parameter < failureInducingCombination.length; ++parameter) {
            if (failureInducingCombination[parameter] != -1) continue;
            IntArraySet forbiddenValues = new IntArraySet();
            forbiddenValues.add(failure[parameter]);
            for (int[] combination : lastFeedback) {
                forbiddenValues.add(combination[parameter]);
            }
            Optional<ParameterValuePair> pv = this.selectBestValue(parameter, (IntSet)forbiddenValues, result);
            result[parameter] = pv.isPresent() ? pv.get().getValue() : ThreadLocalRandom.current().nextInt(0, this.model.getParameterSize(parameter));
        }
        return result;
    }

    private static /* synthetic */ void lambda$getMutatedTestCase$0(IntSet forbiddenValues, int parameter, int[] m) {
        forbiddenValues.add(m[parameter]);
    }
}

