/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg;

import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.report.Reporter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Objects;

public class AetgSatConfiguration {
    private static final int DEFAULT_NUMBER_OF_CANDIDATES = 50;
    private static final int DEFAULT_NUMBER_OF_TRIES = 5;
    private final int numberOfCandidates;
    private final int numberOfTries;
    private final TestModel model;
    private final Reporter reporter;

    private AetgSatConfiguration(Builder builder) {
        this.numberOfCandidates = builder.numberOfCandidates;
        this.numberOfTries = builder.numberOfTries;
        this.model = Objects.requireNonNull(builder.model);
        this.reporter = Objects.requireNonNull(builder.reporter);
    }

    public static Builder aetgSatConfiguration() {
        return new Builder();
    }

    public int getNumberOfCandidates() {
        return this.numberOfCandidates;
    }

    public int getMaximumNumberOfTries() {
        return this.numberOfTries;
    }

    public TestModel getModel() {
        return this.model;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public static class Builder {
        private int numberOfCandidates = 50;
        private int numberOfTries = 5;
        private TestModel model;
        private Reporter reporter = Reporter.getEmptyReporter();

        public Builder reporter(Reporter reporter) {
            Preconditions.notNull(reporter);
            this.reporter = reporter;
            return this;
        }

        public Builder model(TestModel model) {
            Preconditions.notNull(model);
            this.model = model;
            return this;
        }

        public Builder withNumberOfCandidates(int numberOfCandidates) {
            Preconditions.check(numberOfCandidates > 0);
            this.numberOfCandidates = numberOfCandidates;
            return this;
        }

        public Builder withNumberOfTries(int numberOfTries) {
            Preconditions.check(numberOfTries > 0);
            this.numberOfTries = numberOfTries;
            return this;
        }

        public AetgSatConfiguration build() {
            return new AetgSatConfiguration(this);
        }
    }
}

