/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg;

import de.rwth.swc.coffee4j.algorithmic.constraint.DynamicHardConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class CoverageMap {
    private final Set<int[]> combinations;
    private final int length;
    private final DynamicHardConstraintChecker checker;

    CoverageMap(int[] parameterSizes, int strength, DynamicHardConstraintChecker checker) {
        this(Combinator.computeCombinations(parameterSizes, strength), parameterSizes.length, checker);
    }

    CoverageMap(Set<int[]> combinations, int length, DynamicHardConstraintChecker checker) {
        Preconditions.notNull(combinations);
        Preconditions.check(!combinations.isEmpty());
        Preconditions.check(combinations.stream().allMatch(s -> ((int[])s).length == length));
        this.combinations = checker.getInvolvedParameters().isEmpty() ? new HashSet<int[]>(combinations) : combinations.stream().filter(checker::isValid).collect(Collectors.toSet());
        this.length = length;
        this.checker = checker;
    }

    void addForbiddenCombination(int[] combination) {
        this.checker.addConstraint(combination);
        this.combinations.removeIf(c -> !this.checker.isValid((int[])c));
    }

    boolean hasUncoveredCombinations() {
        return !this.combinations.isEmpty();
    }

    void updateSubCombinationCoverage(int[] testCase) {
        this.combinations.removeIf(c -> CombinationUtil.contains(testCase, c));
    }

    long getNumberOfUncoveredCombinations(int[] testCase) {
        return this.combinations.stream().filter(c -> this.contains(testCase, (int[])c)).count();
    }

    private boolean contains(int[] testCase, int[] combination) {
        for (int parameter = 0; parameter < testCase.length; ++parameter) {
            if (testCase[parameter] == -1 || combination[parameter] == -1 || testCase[parameter] == combination[parameter]) continue;
            return false;
        }
        return true;
    }

    ParameterValuePair getMostCommonValue(Set<ParameterValuePair> forbiddenPairs, IntSet forbiddenParameters) {
        int bestValue = -1;
        int bestParameter = -1;
        int highestCount = 0;
        for (int parameter = 0; parameter < this.length; ++parameter) {
            if (forbiddenParameters.contains(parameter)) continue;
            Int2IntArrayMap valueCount = new Int2IntArrayMap();
            for (int[] combination : this.combinations) {
                if (combination[parameter] == -1 || forbiddenPairs.contains(new ParameterValuePair(parameter, combination[parameter]))) continue;
                valueCount.put(combination[parameter], valueCount.getOrDefault(combination[parameter], 0) + 1);
            }
            Optional<Int2IntMap.Entry> best = valueCount.int2IntEntrySet().stream().max(Comparator.comparing(Int2IntMap.Entry::getIntValue));
            if (!best.isPresent() || best.get().getIntValue() <= highestCount) continue;
            bestParameter = parameter;
            bestValue = best.get().getIntKey();
            highestCount = best.get().getIntValue();
        }
        return new ParameterValuePair(bestParameter, bestValue);
    }

    int getNumberOfUncoveredCombinations() {
        return this.combinations.size();
    }
}

