/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.constraint.HardConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.GroupSpecificTestModel;
import de.rwth.swc.coffee4j.algorithmic.report.Reporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroup;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.AetgSatConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced.AdvancedAetgSatAlgorithm;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class AdvancedAetgSat
implements TestInputGroupGenerator {
    private static final String DISPLAY_NAME = "Positive AetgSatAlgorithm Tests";

    public Set<Supplier<TestInputGroup>> generate(CompleteTestModel model, Reporter reporter) {
        if (model.getPositiveTestingStrength() == 0) {
            return Collections.emptySet();
        }
        return Collections.singleton(() -> {
            ConstraintChecker constraintChecker = new HardConstraintCheckerFactory().createConstraintChecker(model);
            GroupSpecificTestModel groupModel = GroupSpecificTestModel.positive(model, constraintChecker);
            List<int[]> testInputs = new AdvancedAetgSatAlgorithm(AetgSatConfiguration.aetgSatConfiguration().model(groupModel).build()).generate();
            FaultCharacterizationConfiguration faultCharacterizationConfiguration = new FaultCharacterizationConfiguration(groupModel, reporter);
            return new TestInputGroup(DISPLAY_NAME, testInputs, faultCharacterizationConfiguration);
        });
    }
}

