/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced;

import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.AetgSatConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced.MixedStrengthCoverageMap;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced.SeedCoverageMap;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;

public class AdvancedAetgSatAlgorithm {
    private final AetgSatConfiguration configuration;
    private final TestModel model;
    private final MixedStrengthCoverageMap coverageMap;
    private final SeedCoverageMap seedCoverageMap;
    private final IntList parameterIndices;
    private final int totalValues;
    private final Random random = ThreadLocalRandom.current();

    public AdvancedAetgSatAlgorithm(AetgSatConfiguration configuration) {
        Preconditions.notNull(configuration, "configuration required");
        this.configuration = Preconditions.notNull(configuration);
        this.model = configuration.getModel();
        this.coverageMap = new MixedStrengthCoverageMap(this.model);
        this.seedCoverageMap = new SeedCoverageMap(this.model);
        this.parameterIndices = new IntArrayList();
        for (int i = 0; i < this.model.getNumberOfParameters(); ++i) {
            this.parameterIndices.add(i);
        }
        this.totalValues = Arrays.stream(this.model.getParameterSizes()).reduce(Integer::sum).orElse(0);
    }

    public List<int[]> generate() {
        ArrayList<int[]> result = new ArrayList<int[]>();
        Optional<int[]> nextTestCase = this.getNextTestCase();
        while (nextTestCase.isPresent()) {
            this.coverageMap.updateSubCombinationCoverage(nextTestCase.get());
            result.add(nextTestCase.get());
            nextTestCase = this.getNextTestCase();
        }
        return result;
    }

    private Optional<int[]> getNextTestCase() {
        if (!this.coverageMap.hasUncoveredCombinations()) {
            return Optional.empty();
        }
        int[] startTestCase = this.seedCoverageMap.getMostImportantPartialTestCase();
        return IntStream.range(0, this.configuration.getNumberOfCandidates()).mapToObj(index -> startTestCase).map(this::getTestCaseWithFixedValues).filter(Optional::isPresent).map(Optional::get).max(Comparator.comparing(this.coverageMap::getNumberOfUncoveredCombinations));
    }

    private Optional<int[]> getTestCaseWithFixedValues(int[] fixedValues) {
        int[] testCase = Arrays.copyOf(fixedValues, fixedValues.length);
        boolean couldExtendTestCaseByFirstValue = this.extendTestCaseByFirstValue(testCase);
        if (!couldExtendTestCaseByFirstValue) {
            return Optional.empty();
        }
        Collections.shuffle(this.parameterIndices, this.random);
        IntListIterator intListIterator = this.parameterIndices.iterator();
        while (intListIterator.hasNext()) {
            int parameter = (Integer)intListIterator.next();
            if (testCase[parameter] != -1) continue;
            Optional<ParameterValuePair> best = this.selectBestSatisfiableValue(testCase, parameter);
            if (best.isPresent()) {
                testCase[best.get().getParameter()] = best.get().getValue();
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(testCase);
    }

    private boolean extendTestCaseByFirstValue(int[] testCase) {
        HashSet<ParameterValuePair> forbiddenPairs = new HashSet<ParameterValuePair>();
        IntArraySet forbiddenParameters = new IntArraySet((IntCollection)this.getFixedParameters(testCase));
        boolean sat = false;
        ParameterValuePair first = null;
        while (!sat) {
            if (forbiddenPairs.size() >= this.totalValues) {
                return false;
            }
            first = this.selectFirstFactorValue(forbiddenPairs, (IntSet)forbiddenParameters);
            sat = this.checkTestCase(testCase, first);
            if (sat) continue;
            forbiddenPairs.add(first);
        }
        testCase[first.getParameter()] = first.getValue();
        return true;
    }

    private IntSet getFixedParameters(int[] testCase) {
        IntOpenHashSet fixedParameters = new IntOpenHashSet(testCase.length);
        for (int i = 0; i < testCase.length; ++i) {
            if (testCase[i] == -1) continue;
            fixedParameters.add(i);
        }
        return fixedParameters;
    }

    private ParameterValuePair selectFirstFactorValue(Set<ParameterValuePair> forbiddenPairs, IntSet forbiddenParameters) {
        return this.coverageMap.getMostCommonValue(forbiddenPairs, forbiddenParameters);
    }

    private Optional<ParameterValuePair> selectBestSatisfiableValue(int[] testCase, int parameter) {
        int maxTries = this.configuration.getMaximumNumberOfTries();
        IntArraySet forbiddenValues = new IntArraySet();
        boolean sat = false;
        int tries = 0;
        Optional<ParameterValuePair> best = Optional.empty();
        while (!sat && tries < maxTries && (best = this.selectBestValue(parameter, (IntSet)forbiddenValues, testCase)).isPresent()) {
            sat = this.checkTestCase(testCase, best.get());
            if (sat) continue;
            forbiddenValues.add(best.get().getValue());
            best = Optional.empty();
        }
        return best;
    }

    private Optional<ParameterValuePair> selectBestValue(int parameter, IntSet forbiddenValues, int[] testCase) {
        int[] candidate = Arrays.copyOf(testCase, testCase.length);
        int bestValue = -1;
        long bestValueResult = -1L;
        for (int value = 0; value < this.model.getParameterSize(parameter); ++value) {
            if (forbiddenValues.contains(value)) continue;
            candidate[parameter] = value;
            long valueResult = this.coverageMap.getNumberOfUncoveredCombinations(candidate);
            if (valueResult <= bestValueResult) continue;
            bestValueResult = valueResult;
            bestValue = value;
        }
        if (bestValue == -1) {
            return Optional.empty();
        }
        return Optional.of(new ParameterValuePair(parameter, bestValue));
    }

    private boolean checkTestCase(int[] testCase, ParameterValuePair pair) {
        return this.model.getConstraintChecker().isExtensionValid(testCase, pair.getParameter(), pair.getValue());
    }
}

