/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced;

import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveStrengthGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.ParameterValuePair;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class MixedStrengthCoverageMap {
    private final Set<int[]> combinations;
    private final int length;

    MixedStrengthCoverageMap(TestModel testModel) {
        Preconditions.notNull(testModel, "testModel required");
        this.length = testModel.getNumberOfParameters();
        this.combinations = this.computeCombination(testModel);
    }

    private Set<int[]> computeCombination(TestModel testModel) {
        Set<IntSet> parameterCombinations = this.computeParameterCombinations(testModel);
        return parameterCombinations.stream().map(parameterCombination -> Combinator.computeCombinations(testModel.getParameterSizes(), parameterCombination)).flatMap(Collection::stream).filter(testModel.getConstraintChecker()::isValid).collect(Collectors.toSet());
    }

    private Set<IntSet> computeParameterCombinations(TestModel testModel) {
        Set mixedStrengthParameterCombinations = testModel.getMixedStrengthGroups().stream().map(PrimitiveStrengthGroup::getAllSubGroups).flatMap(Collection::stream).collect(Collectors.toSet());
        Set defaultStrengthParameterCombinations = Combinator.computeParameterCombinations(IntStream.range(0, testModel.getNumberOfParameters()).toArray(), testModel.getDefaultTestingStrength()).stream().filter(defaultCombination -> mixedStrengthParameterCombinations.stream().noneMatch(mixedCombination -> mixedCombination.containsAll((IntCollection)defaultCombination))).collect(Collectors.toSet());
        HashSet<IntSet> allParameterCombinations = new HashSet<IntSet>(mixedStrengthParameterCombinations.size() + defaultStrengthParameterCombinations.size());
        allParameterCombinations.addAll(mixedStrengthParameterCombinations);
        allParameterCombinations.addAll(defaultStrengthParameterCombinations);
        return allParameterCombinations;
    }

    boolean hasUncoveredCombinations() {
        return !this.combinations.isEmpty();
    }

    void updateSubCombinationCoverage(int[] testCase) {
        this.combinations.removeIf(c -> this.contains(testCase, (int[])c));
    }

    long getNumberOfUncoveredCombinations(int[] testCase) {
        return this.combinations.stream().filter(c -> this.contains(testCase, (int[])c)).count();
    }

    private boolean contains(int[] testCase, int[] combination) {
        for (int parameter = 0; parameter < testCase.length; ++parameter) {
            if (testCase[parameter] == -1 || combination[parameter] == -1 || testCase[parameter] == combination[parameter]) continue;
            return false;
        }
        return true;
    }

    ParameterValuePair getMostCommonValue(Set<ParameterValuePair> forbiddenPairs, IntSet forbiddenParameters) {
        int bestValue = -1;
        int bestParameter = -1;
        int highestCount = 0;
        for (int parameter = 0; parameter < this.length; ++parameter) {
            if (forbiddenParameters.contains(parameter)) continue;
            Int2IntArrayMap valueCount = new Int2IntArrayMap();
            for (int[] combination : this.combinations) {
                if (combination[parameter] == -1 || forbiddenPairs.contains(new ParameterValuePair(parameter, combination[parameter]))) continue;
                valueCount.put(combination[parameter], valueCount.getOrDefault(combination[parameter], 0) + 1);
            }
            Optional<Int2IntMap.Entry> best = valueCount.int2IntEntrySet().stream().max(Comparator.comparing(Int2IntMap.Entry::getIntValue));
            if (!best.isPresent() || best.get().getIntValue() <= highestCount) continue;
            bestParameter = parameter;
            bestValue = best.get().getIntKey();
            highestCount = best.get().getIntValue();
        }
        return new ParameterValuePair(bestParameter, bestValue);
    }
}

