/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.aetg.advanced;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveSeed;
import de.rwth.swc.coffee4j.algorithmic.model.SeedMode;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.PredicateUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class SeedCoverageMap {
    private final List<PrimitiveSeed> missingPrioritizedSeeds;
    private final List<PrimitiveSeed> missingUnprioritizedSeeds;
    private final int numberOfParameters;
    private final ConstraintChecker constraintChecker;

    SeedCoverageMap(TestModel model) {
        this.numberOfParameters = model.getNumberOfParameters();
        this.constraintChecker = model.getConstraintChecker();
        this.missingPrioritizedSeeds = model.getSeeds().stream().filter(PrimitiveSeed::hasPriority).sorted(Comparator.comparingDouble(PrimitiveSeed::getPriority).reversed()).collect(Collectors.toList());
        this.missingUnprioritizedSeeds = model.getSeeds().stream().filter(PredicateUtil.not(PrimitiveSeed::hasPriority)).sorted(Comparator.comparingInt(seed -> CombinationUtil.numberOfSetParameters(seed.getCombination()))).collect(Collectors.toList());
    }

    int[] getMostImportantPartialTestCase() {
        int[] testCase = CombinationUtil.emptyCombination(this.numberOfParameters);
        boolean testCaseAddedInLastIteration = true;
        boolean containsSuspiciousSeed = false;
        while (!(this.missingPrioritizedSeeds.isEmpty() && this.missingUnprioritizedSeeds.isEmpty() || !testCaseAddedInLastIteration)) {
            Optional<PrimitiveSeed> nextSeed = this.getMostImportantCompatibleTestCase(testCase, containsSuspiciousSeed);
            if (nextSeed.isPresent()) {
                PrimitiveSeed seed = nextSeed.get();
                CombinationUtil.add(testCase, seed.getCombination());
                this.missingPrioritizedSeeds.remove(seed);
                this.missingUnprioritizedSeeds.remove(seed);
                testCaseAddedInLastIteration = true;
                containsSuspiciousSeed = seed.getMode() == SeedMode.EXCLUSIVE;
                continue;
            }
            testCaseAddedInLastIteration = false;
        }
        return testCase;
    }

    private Optional<PrimitiveSeed> getMostImportantCompatibleTestCase(int[] testCase, boolean containsSuspiciousSeed) {
        for (PrimitiveSeed seed : this.missingPrioritizedSeeds) {
            if (seed.getMode() == SeedMode.EXCLUSIVE && containsSuspiciousSeed || !CombinationUtil.canBeAdded(testCase, seed.getCombination(), this.constraintChecker)) continue;
            return Optional.of(seed);
        }
        for (PrimitiveSeed seed : this.missingUnprioritizedSeeds) {
            if (seed.getMode() == SeedMode.EXCLUSIVE && containsSuspiciousSeed || !CombinationUtil.canBeAdded(testCase, seed.getCombination(), this.constraintChecker)) continue;
            return Optional.of(seed);
        }
        return Optional.empty();
    }
}

