/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;

public class CombinationPartitioner {
    private static final String COMBINATIONS_NOT_NULL = "Combinations must not be null";
    private static final String COMBINATION_NOT_NULL = "Combination must not be null";
    private static final String VALID_PARAMETER_INDEX = "The index of the parameter must be at least 0";
    private static final String VALID_NUMBER_OF_VALUES = "The number of values for a parameter must be greater than 0";
    private static final String PARAMETER_NOT_IN_COMBINATION = "The partitioning parameter is not in the combination";
    private final int partitioningParameter;
    private final Int2ObjectMap<HashSet<IntArrayWrapper>> partitioner;

    public CombinationPartitioner(Collection<int[]> combinations, int partitioningParameter, int numberOfValues) {
        Preconditions.notNull(combinations, COMBINATIONS_NOT_NULL);
        Preconditions.check(partitioningParameter >= 0, VALID_PARAMETER_INDEX);
        Preconditions.check(numberOfValues > 0, VALID_NUMBER_OF_VALUES);
        this.partitioningParameter = partitioningParameter;
        this.partitioner = new Int2ObjectOpenHashMap(numberOfValues + 1);
        for (int i = 0; i < numberOfValues; ++i) {
            this.partitioner.put(i, new HashSet());
        }
        this.partitioner.put(-1, new HashSet());
        for (int[] combination : combinations) {
            Preconditions.notNull(combination, COMBINATION_NOT_NULL);
            Preconditions.check(combination.length > partitioningParameter, PARAMETER_NOT_IN_COMBINATION);
            this.addCombination(combination);
        }
    }

    public void addCombination(int[] combination) {
        Preconditions.notNull(combination, COMBINATION_NOT_NULL);
        Preconditions.check(combination.length > this.partitioningParameter, PARAMETER_NOT_IN_COMBINATION);
        ((HashSet)this.partitioner.get(combination[this.partitioningParameter])).add(IntArrayWrapper.wrap(combination));
    }

    public void removeCombination(int[] combination) {
        Preconditions.notNull(combination, COMBINATION_NOT_NULL);
        Preconditions.check(combination.length > this.partitioningParameter, PARAMETER_NOT_IN_COMBINATION);
        ((HashSet)this.partitioner.get(combination[this.partitioningParameter])).remove(IntArrayWrapper.wrap(combination));
    }

    public Optional<int[]> extendSuitableCombination(int[] combination, ConstraintChecker constraintChecker) {
        Preconditions.notNull(combination, COMBINATION_NOT_NULL);
        Preconditions.check(combination.length > this.partitioningParameter, PARAMETER_NOT_IN_COMBINATION);
        LinkedList possibleCombinations = new LinkedList((Collection)this.partitioner.get(combination[this.partitioningParameter]));
        possibleCombinations.addAll((Collection)this.partitioner.get(-1));
        for (IntArrayWrapper possibleCombination : possibleCombinations) {
            if (!this.tryToAdd(possibleCombination.getArray(), combination, constraintChecker)) continue;
            return Optional.of(possibleCombination.getArray());
        }
        return Optional.empty();
    }

    private boolean tryToAdd(int[] baseCombination, int[] combinationToBeAdded, ConstraintChecker constraintChecker) {
        if (CombinationUtil.canBeAdded(baseCombination, combinationToBeAdded, constraintChecker)) {
            CombinationUtil.add(baseCombination, combinationToBeAdded);
            return true;
        }
        return false;
    }
}

