/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.GroupSpecificTestModel;
import de.rwth.swc.coffee4j.algorithmic.report.Reporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroup;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.IpogAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.IpogConfiguration;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class Ipog
implements TestInputGroupGenerator {
    private static final String DISPLAY_NAME = "Ipog";
    private final IpogConfiguration configuration;

    public Ipog() {
        this(IpogConfiguration.defaultConfiguration());
    }

    public Ipog(IpogConfiguration configuration) {
        this.configuration = Preconditions.notNull(configuration);
    }

    public Set<Supplier<TestInputGroup>> generate(CompleteTestModel model, Reporter reporter) {
        if (model.getPositiveTestingStrength() == 0) {
            return Collections.emptySet();
        }
        return Collections.singleton(() -> {
            ConstraintChecker constraintChecker = this.configuration.getConstraintCheckerFactory().createConstraintChecker(model);
            GroupSpecificTestModel groupModel = GroupSpecificTestModel.positive(model, constraintChecker);
            List<int[]> testInputs = new IpogAlgorithm(groupModel).generate();
            FaultCharacterizationConfiguration faultCharacterizationConfiguration = new FaultCharacterizationConfiguration(groupModel, reporter);
            return new TestInputGroup(DISPLAY_NAME, testInputs, faultCharacterizationConfiguration);
        });
    }
}

