/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog;

import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveSeed;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.CombinationPartitioner;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.EfficientCoverageMap;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.MixedStrengthParameterCombinationFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.MixedStrengthParameterOrder;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.ParameterCombinationFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.ParameterOrder;
import de.rwth.swc.coffee4j.algorithmic.util.ArrayUtil;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class IpogAlgorithm {
    private final TestModel model;
    private final ParameterOrder order = new MixedStrengthParameterOrder();
    private final ParameterCombinationFactory combinationFactory = new MixedStrengthParameterCombinationFactory();

    public IpogAlgorithm(TestModel testModel) {
        this.model = Preconditions.notNull(testModel);
    }

    public List<int[]> generate() {
        int strength = this.model.getDefaultTestingStrength();
        Int2IntMap parameters = this.convertToFactors();
        int[] initialParameters = this.order.getInitialParameters(this.model);
        List<int[]> testSuite = this.buildInitialTestSuite(parameters, initialParameters);
        this.addSeedsToInitialTestSuite(testSuite, this.model.getSeeds());
        int[] remainingParameters = this.order.getRemainingParameters(this.model);
        if (strength > 0 || this.model.getMixedStrengthGroups().size() > 1) {
            this.extendInitialTestSuite(parameters, initialParameters, testSuite, remainingParameters);
        }
        this.fillEmptyValues(testSuite, parameters);
        return testSuite;
    }

    private Int2IntMap convertToFactors() {
        Int2IntOpenHashMap parameters = new Int2IntOpenHashMap(this.model.getNumberOfParameters());
        for (int i = 0; i < this.model.getNumberOfParameters(); ++i) {
            parameters.put(i, this.model.getParameterSize(i));
        }
        return parameters;
    }

    private List<int[]> buildInitialTestSuite(Int2IntMap allParameters, int[] initialParameters) {
        if (initialParameters.length == 0) {
            return List.of();
        }
        List<int[]> testSuite = Combinator.computeCartesianProduct(this.subMap(allParameters, initialParameters), allParameters.size());
        return testSuite.stream().filter(this.model.getConstraintChecker()::isValid).collect(Collectors.toList());
    }

    private Int2IntMap subMap(Int2IntMap original, int[] keys) {
        Int2IntOpenHashMap subMap = new Int2IntOpenHashMap();
        for (int i = 0; i < original.size(); ++i) {
            if (!ArrayUtil.contains(keys, i)) continue;
            subMap.put(i, original.get(i));
        }
        return subMap;
    }

    private void addSeedsToInitialTestSuite(List<int[]> testSuite, List<PrimitiveSeed> seeds) {
        for (PrimitiveSeed seed : seeds) {
            int[] combination = seed.getCombination();
            if (this.tryToAdd(testSuite, combination) || !this.model.getConstraintChecker().isValid(combination)) continue;
            testSuite.add(combination);
        }
    }

    private boolean tryToAdd(List<int[]> testSuite, int[] toBeAdded) {
        for (int[] testCase : testSuite) {
            if (!CombinationUtil.canBeAdded(testCase, toBeAdded, this.model.getConstraintChecker())) continue;
            CombinationUtil.add(testCase, toBeAdded);
            return true;
        }
        return false;
    }

    private void extendInitialTestSuite(Int2IntMap parameters, int[] initialParameters, List<int[]> testSuite, int[] remainingParameters) {
        IntArrayList coveredParameters = new IntArrayList(initialParameters);
        for (int nextParameter : remainingParameters) {
            CoverageMap coverageMap;
            List<IntSet> parameterCombinations = this.combinationFactory.create(coveredParameters.toIntArray(), nextParameter, this.model);
            if (!parameterCombinations.isEmpty() && (coverageMap = this.horizontalExtension(nextParameter, testSuite, parameters, parameterCombinations)).mayHaveUncoveredCombinations()) {
                this.verticalExtension(nextParameter, parameters, testSuite, coverageMap);
            }
            coveredParameters.add(nextParameter);
        }
    }

    private CoverageMap horizontalExtension(int nextParameter, List<int[]> testSuite, Int2IntMap allParameters, List<IntSet> parameterCombinations) {
        EfficientCoverageMap coverageMap = new EfficientCoverageMap(parameterCombinations, nextParameter, allParameters, this.model.getConstraintChecker());
        if (!this.model.getSeeds().isEmpty()) {
            for (int[] testInput : testSuite) {
                coverageMap.markAsCovered(testInput);
            }
        }
        for (int[] testInput : testSuite) {
            this.addValueWithHighestCoverageGain(coverageMap, testInput, nextParameter);
            coverageMap.markAsCovered(testInput);
            if (coverageMap.mayHaveUncoveredCombinations()) continue;
            break;
        }
        return coverageMap;
    }

    private void addValueWithHighestCoverageGain(CoverageMap coverageMap, int[] partialTestInput, int parameterIndex) {
        if (this.skipAlreadyParameterValues(partialTestInput, parameterIndex)) {
            return;
        }
        int[] gains = coverageMap.computeGainsOfFixedParameter(partialTestInput);
        for (int i = 0; i < gains.length; ++i) {
            int valueWithHighestGain;
            partialTestInput[parameterIndex] = valueWithHighestGain = this.getValueWithHighestGain(gains);
            if (this.model.getConstraintChecker().isValid(partialTestInput)) {
                return;
            }
            partialTestInput[parameterIndex] = -1;
            gains[valueWithHighestGain] = -1;
        }
        throw new IllegalStateException("ERROR: test input " + Arrays.toString(partialTestInput) + " cannot be updated for parameter " + parameterIndex);
    }

    private boolean skipAlreadyParameterValues(int[] partialTestInput, int parameterIndex) {
        return partialTestInput[parameterIndex] != -1;
    }

    private int getValueWithHighestGain(int[] gains) {
        int valueWithHighestGain = 0;
        for (int value = 0; value < gains.length; ++value) {
            if (gains[value] <= gains[valueWithHighestGain]) continue;
            valueWithHighestGain = value;
        }
        return valueWithHighestGain;
    }

    private void verticalExtension(int index, Int2IntMap parameters, List<int[]> testSuite, CoverageMap coverageMap) {
        CombinationPartitioner combinationPartitioner = new CombinationPartitioner(this.getIncompleteCombinations(index, testSuite), index, parameters.get(index));
        while (coverageMap.mayHaveUncoveredCombinations()) {
            Optional<int[]> uncoveredCombination = coverageMap.getUncoveredCombination();
            if (!uncoveredCombination.isPresent()) continue;
            int[] combination = uncoveredCombination.get();
            Optional<int[]> candidate = this.addCombinationToTestInput(combination, combinationPartitioner, testSuite);
            if (candidate.isPresent()) {
                int[] extension = candidate.get();
                coverageMap.markAsCovered(extension);
                if (!CombinationUtil.containsAllParameters(extension, index)) continue;
                combinationPartitioner.removeCombination(extension);
                continue;
            }
            coverageMap.markAsCovered(combination);
        }
    }

    private List<int[]> getIncompleteCombinations(int index, List<int[]> testSuite) {
        LinkedList<int[]> incompleteCombinations = new LinkedList<int[]>();
        for (int[] testInput : testSuite) {
            if (CombinationUtil.containsAllParameters(testInput, index)) continue;
            incompleteCombinations.add(testInput);
        }
        return incompleteCombinations;
    }

    private Optional<int[]> addCombinationToTestInput(int[] combination, CombinationPartitioner combinationPartitioner, List<int[]> testSuite) {
        if (!this.model.getConstraintChecker().isValid(combination)) {
            return Optional.empty();
        }
        Optional<int[]> testInput = combinationPartitioner.extendSuitableCombination(combination, this.model.getConstraintChecker());
        if (testInput.isPresent()) {
            return testInput;
        }
        testSuite.add(combination);
        combinationPartitioner.addCombination(combination);
        return Optional.of(combination);
    }

    private void fillEmptyValues(List<int[]> testSuite, Int2IntMap parameters) {
        for (int[] testInput : testSuite) {
            for (int parameter = 0; parameter < parameters.size(); ++parameter) {
                if (testInput[parameter] != -1) continue;
                this.fillEmptyValue(testInput, parameter, parameters.get(parameter));
            }
        }
    }

    private void fillEmptyValue(int[] testInput, int parameter, int parameterSize) {
        int value = 0;
        while (value < parameterSize) {
            if (!this.model.getConstraintChecker().isExtensionValid(testInput, parameter, value++)) continue;
            testInput[parameter] = value;
            return;
        }
        throw new IllegalStateException("ERROR: could not replace random value for parameter " + parameter + " in test input: " + Arrays.toString(testInput));
    }
}

