/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog;

import de.rwth.swc.coffee4j.algorithmic.model.PrimitiveStrengthGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog.ParameterCombinationFactory;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MixedStrengthParameterCombinationFactory
implements ParameterCombinationFactory {
    @Override
    public List<IntSet> create(int[] oldParameters, int nextParameter, TestModel model) {
        Set<IntSet> mixedStrengthGroups = this.calculateMixedStrengthGroups(oldParameters, nextParameter, model);
        Set<IntSet> defaultStrengthGroups = this.calculateMissingDefaultStrengthGroups(oldParameters, model.getDefaultTestingStrength(), mixedStrengthGroups);
        ArrayList<IntSet> strengthGroups = new ArrayList<IntSet>(mixedStrengthGroups.size() + defaultStrengthGroups.size());
        strengthGroups.addAll(mixedStrengthGroups);
        strengthGroups.addAll(defaultStrengthGroups);
        return strengthGroups;
    }

    private Set<IntSet> calculateMixedStrengthGroups(int[] oldParameters, int nextParameter, TestModel model) {
        IntOpenHashSet relevantParameters = new IntOpenHashSet(oldParameters);
        relevantParameters.add(nextParameter);
        return model.getMixedStrengthGroups().stream().map(PrimitiveStrengthGroup::getAllSubGroups).flatMap(Collection::stream).filter(arg_0 -> ((IntSet)relevantParameters).containsAll(arg_0)).filter(set -> set.contains(nextParameter)).map(IntOpenHashSet::new).map(set -> this.removeParameterFromSet((IntSet)set, nextParameter)).collect(Collectors.toSet());
    }

    private IntSet removeParameterFromSet(IntSet set, int parameterToRemove) {
        set.remove(parameterToRemove);
        return set;
    }

    private Set<IntSet> calculateMissingDefaultStrengthGroups(int[] oldParameters, int strength, Set<IntSet> mixedStrengthGroups) {
        if (strength == 1 && mixedStrengthGroups.isEmpty()) {
            return Set.of(IntSets.EMPTY_SET);
        }
        if (strength == 0 || strength == 1) {
            return Set.of();
        }
        return Combinator.computeParameterCombinations(oldParameters, strength - 1).stream().filter(defaultStrengthGroup -> mixedStrengthGroups.stream().noneMatch(mixedStrengthGroup -> mixedStrengthGroup.containsAll((IntCollection)defaultStrengthGroup))).collect(Collectors.toSet());
    }
}

