/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipog;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Optional;

final class ParameterCombinationCoverageMap {
    private final int numberOfCombinations;
    private final int numberOfParameters;
    private final int[] parameterCombination;
    private final int[] parameterSizes;
    private final int[] parameterMultipliers;
    private final BitSet coverageMap;
    private final ConstraintChecker constraintChecker;

    ParameterCombinationCoverageMap(IntSet parameterCombination, int fixedParameter, Int2IntMap parameters, ConstraintChecker constraintChecker) {
        this.parameterCombination = new int[parameterCombination.size() + 1];
        parameterCombination.toArray(this.parameterCombination);
        this.parameterCombination[parameterCombination.size()] = fixedParameter;
        this.parameterSizes = this.parameterSizesAsArray(parameters);
        this.parameterMultipliers = this.parameterMultipliersAsArray();
        this.numberOfCombinations = this.numberOfCombinations();
        this.numberOfParameters = parameters.size();
        this.coverageMap = new BitSet(this.numberOfCombinations);
        this.constraintChecker = constraintChecker;
    }

    private int[] parameterSizesAsArray(Int2IntMap parameters) {
        int[] parameterSizesAsArray = new int[this.parameterCombination.length];
        for (int i = 0; i < this.parameterCombination.length; ++i) {
            parameterSizesAsArray[i] = parameters.get(this.parameterCombination[i]);
        }
        return parameterSizesAsArray;
    }

    private int[] parameterMultipliersAsArray() {
        int[] parameterMultipliersAsArray = new int[this.parameterSizes.length];
        int currentMultiplier = 1;
        for (int i = 0; i < this.parameterSizes.length; ++i) {
            parameterMultipliersAsArray[i] = currentMultiplier;
            currentMultiplier *= this.parameterSizes[i];
        }
        return parameterMultipliersAsArray;
    }

    private int numberOfCombinations() {
        int count = 1;
        for (int parameterSize : this.parameterSizes) {
            count *= parameterSize;
        }
        return count;
    }

    boolean mayHaveUncoveredCombinations() {
        return this.coverageMap.cardinality() < this.numberOfCombinations;
    }

    void markAsCovered(int[] combination) {
        int index = this.getIndexUntil(combination, this.parameterCombination.length);
        if (!this.coverageMap.get(index)) {
            this.markIndexAsCovered(index);
        }
    }

    private void markIndexAsCovered(int index) {
        this.coverageMap.set(index);
    }

    private int getIndexUntil(int[] combination, int parameterCount) {
        int index = 0;
        for (int i = 0; i < parameterCount; ++i) {
            int parameter = this.parameterCombination[i];
            index += combination[parameter] * this.parameterMultipliers[i];
        }
        return index;
    }

    Optional<int[]> getUncoveredCombination() {
        if (!this.mayHaveUncoveredCombinations()) {
            return Optional.empty();
        }
        int index = this.coverageMap.nextClearBit(0);
        if (index >= this.numberOfCombinations) {
            throw new IllegalStateException("corrupt invariant");
        }
        int[] uncoveredCombination = this.getCombination(index);
        if (this.constraintChecker.isValid(uncoveredCombination)) {
            return Optional.of(uncoveredCombination);
        }
        this.markAsCovered(uncoveredCombination);
        if (this.mayHaveUncoveredCombinations()) {
            return this.getUncoveredCombination();
        }
        return Optional.empty();
    }

    private int[] getCombination(int index) {
        int[] combination = new int[this.numberOfParameters];
        Arrays.fill(combination, -1);
        for (int i = this.parameterCombination.length - 1; i >= 0; --i) {
            int value;
            int parameter = this.parameterCombination[i];
            int parameterIndexPart = index - index % this.parameterMultipliers[i];
            combination[parameter] = value = parameterIndexPart / this.parameterMultipliers[i];
            index -= parameterIndexPart;
        }
        return combination;
    }

    void addGainsOfFixedParameter(int[] combination, int[] gains) {
        if (!this.mayHaveUncoveredCombinations()) {
            return;
        }
        int fixedParameterIndex = this.parameterCombination.length - 1;
        int baseIndex = this.getIndexUntil(combination, fixedParameterIndex);
        int[] subset = this.createSubsetOfCombination(combination, this.parameterCombination);
        for (int value = 0; value < gains.length; ++value) {
            int index = baseIndex + value * this.parameterMultipliers[fixedParameterIndex];
            if (gains[value] == -1 || this.coverageMap.get(index)) continue;
            subset[fixedParameterIndex] = value;
            if (this.constraintChecker.isDualValid(this.parameterCombination, subset)) {
                int n = value;
                gains[n] = gains[n] + 1;
                continue;
            }
            this.markIndexAsCovered(index);
            gains[value] = -1;
        }
    }

    private int[] createSubsetOfCombination(int[] combination, int[] parameters) {
        int[] subset = new int[parameters.length];
        for (int i = 0; i < subset.length; ++i) {
            subset[i] = combination[parameters[i]];
        }
        return subset;
    }
}

