/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.CoverageMap;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.ParameterCombinationCoverageMap;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class EfficientCoverageMap
implements CoverageMap {
    private static final String PARAMETER_COMBINATIONS_NOT_NULL = "Parameter combinations must not be null";
    private static final String PARAMETER_NOT_VALID = "The parameter index must not be negative";
    private static final String FIXED_PARAMETER_NOT_CONTAINED = "The fixed parameter has to be contained in the parameter map";
    private static final String COMBINATION_NOT_NULL = "Combination cannot be null";
    private static final String PARAMETERS_NOT_NULL = "Parameters cannot be null";
    private final int fixedParameter;
    private final int fixedParameterSize;
    private final Map<IntSet, ParameterCombinationCoverageMap> combinationCoverageMap = new HashMap<IntSet, ParameterCombinationCoverageMap>();
    private final ConstraintChecker constraintChecker;

    EfficientCoverageMap(Collection<IntSet> parameterCombinations, int fixedParameter, Int2IntMap parameters, ConstraintChecker constraintChecker) {
        Preconditions.notNull(parameterCombinations, PARAMETER_COMBINATIONS_NOT_NULL);
        Preconditions.notNull(parameters, PARAMETERS_NOT_NULL);
        Preconditions.check(fixedParameter >= 0, PARAMETER_NOT_VALID);
        Preconditions.check(parameters.containsKey(fixedParameter), FIXED_PARAMETER_NOT_CONTAINED);
        Preconditions.notNull(constraintChecker);
        this.constraintChecker = constraintChecker;
        this.fixedParameter = fixedParameter;
        this.fixedParameterSize = parameters.get(fixedParameter);
        this.constructCombinationCoverageMap(parameterCombinations, fixedParameter, parameters);
    }

    private void constructCombinationCoverageMap(Collection<IntSet> parameterCombinations, int fixedParameter, Int2IntMap parameters) {
        if (parameterCombinations.isEmpty()) {
            parameterCombinations = Collections.singleton(new IntOpenHashSet(0));
        }
        for (IntSet parameterCombination : parameterCombinations) {
            this.combinationCoverageMap.put(parameterCombination, new ParameterCombinationCoverageMap(parameterCombination, fixedParameter, parameters, this.constraintChecker));
        }
    }

    @Override
    public boolean mayHaveUncoveredCombinations() {
        for (ParameterCombinationCoverageMap combinationCoverage : this.combinationCoverageMap.values()) {
            if (!combinationCoverage.mayHaveUncoveredCombinations()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void markAsCovered(int[] combination) {
        Preconditions.notNull(combination, COMBINATION_NOT_NULL);
        if (combination[this.fixedParameter] != -1) {
            Set<ParameterCombinationCoverageMap> relevantCombinationCoverages = this.getRelevantCombinationCoverages(combination);
            for (ParameterCombinationCoverageMap combinationCoverage : relevantCombinationCoverages) {
                combinationCoverage.markAsCovered(combination);
            }
        }
    }

    private Set<ParameterCombinationCoverageMap> getRelevantCombinationCoverages(int[] combination) {
        HashSet<ParameterCombinationCoverageMap> relevantCombinationCoverages = new HashSet<ParameterCombinationCoverageMap>();
        for (Map.Entry<IntSet, ParameterCombinationCoverageMap> entry : this.combinationCoverageMap.entrySet()) {
            if (!CombinationUtil.containsAllParameters(combination, entry.getKey())) continue;
            relevantCombinationCoverages.add(entry.getValue());
        }
        return relevantCombinationCoverages;
    }

    @Override
    public int[] computeGainsOfFixedParameter(int[] combination) {
        Preconditions.notNull(combination, COMBINATION_NOT_NULL);
        int[] gains = new int[this.fixedParameterSize];
        Set<ParameterCombinationCoverageMap> relevantCombinations = this.getRelevantCombinationCoverages(combination);
        for (ParameterCombinationCoverageMap combinationCoverage : relevantCombinations) {
            combinationCoverage.addGainsOfFixedParameter(combination, gains);
        }
        return gains;
    }

    @Override
    public Optional<int[]> getUncoveredCombination() {
        for (ParameterCombinationCoverageMap combinationCoverage : this.combinationCoverageMap.values()) {
            Optional<int[]> uncoveredCombination;
            if (!combinationCoverage.mayHaveUncoveredCombinations() || !(uncoveredCombination = combinationCoverage.getUncoveredCombination()).isPresent()) continue;
            return uncoveredCombination;
        }
        return Optional.empty();
    }
}

