/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.report.Reporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.ParameterCombinationFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.ParameterOrder;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.StrengthBasedParameterCombinationFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.StrengthBasedParameterOrder;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.Objects;

final class IpogAlgorithmConfiguration {
    private final TestModel testModel;
    private final int testingStrength;
    private final ConstraintChecker constraintChecker;
    private final ParameterCombinationFactory factory;
    private final ParameterOrder order;
    private final Reporter reporter;

    private IpogAlgorithmConfiguration(Builder builder) {
        Preconditions.check(builder.testingStrength >= 0);
        this.testModel = Preconditions.notNull(builder.testModel);
        this.testingStrength = builder.testingStrength;
        this.constraintChecker = Preconditions.notNull(builder.constraintChecker);
        this.factory = Preconditions.notNull(builder.factory);
        this.order = Preconditions.notNull(builder.order);
        this.reporter = Preconditions.notNull(builder.reporter);
    }

    TestModel getTestModel() {
        return this.testModel;
    }

    int getTestingStrength() {
        return this.testingStrength;
    }

    ConstraintChecker getConstraintChecker() {
        return this.constraintChecker;
    }

    ParameterCombinationFactory getFactory() {
        return this.factory;
    }

    ParameterOrder getOrder() {
        return this.order;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpogAlgorithmConfiguration that = (IpogAlgorithmConfiguration)o;
        return this.testingStrength == that.testingStrength && Objects.equals(this.testModel, that.testModel) && Objects.equals(this.constraintChecker, that.constraintChecker) && Objects.equals(this.factory, that.factory) && Objects.equals(this.order, that.order) && Objects.equals(this.reporter, that.reporter);
    }

    public int hashCode() {
        return Objects.hash(this.testModel, this.testingStrength, this.constraintChecker, this.factory, this.order, this.reporter);
    }

    public String toString() {
        return "IpogAlgorithmConfiguration{testModel=" + this.testModel + ", testingStrength=" + this.testingStrength + ", constraintChecker=" + this.constraintChecker + ", factory=" + this.factory + ", order=" + this.order + ", reporter=" + this.reporter + "}";
    }

    static Builder ipogConfiguration() {
        return new Builder();
    }

    static final class Builder {
        private TestModel testModel;
        private int testingStrength;
        private ConstraintChecker constraintChecker;
        private ParameterCombinationFactory factory = new StrengthBasedParameterCombinationFactory();
        private ParameterOrder order = new StrengthBasedParameterOrder();
        private Reporter reporter = Reporter.getEmptyReporter();

        Builder() {
        }

        Builder testModel(TestModel testModel) {
            this.testModel = testModel;
            return this;
        }

        Builder testingStrength(int testingStrength) {
            this.testingStrength = testingStrength;
            return this;
        }

        Builder constraintChecker(ConstraintChecker constraintChecker) {
            this.constraintChecker = constraintChecker;
            return this;
        }

        Builder factory(ParameterCombinationFactory factory) {
            this.factory = factory;
            return this;
        }

        Builder order(ParameterOrder order) {
            this.order = order;
            return this;
        }

        Builder reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        IpogAlgorithmConfiguration build() {
            return new IpogAlgorithmConfiguration(this);
        }
    }
}

