/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm;

import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.ParameterCombinationFactory;
import de.rwth.swc.coffee4j.algorithmic.util.ArrayUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;

final class NegativeStrengthBasedParameterCombinationFactory
implements ParameterCombinationFactory {
    private final int[] negativeParameters;
    private final int strengthA;

    NegativeStrengthBasedParameterCombinationFactory(TupleList forbiddenTuples, int strengthA) {
        Preconditions.notNull(forbiddenTuples);
        Preconditions.check(strengthA > 0 && strengthA <= forbiddenTuples.getInvolvedParameters().length);
        this.negativeParameters = Preconditions.notNull(forbiddenTuples).getInvolvedParameters();
        this.strengthA = strengthA;
    }

    @Override
    public Optional<List<IntSet>> create(int[] oldParameters, int nextParameter, int strengthB) {
        if (ArrayUtil.contains(this.negativeParameters, nextParameter)) {
            return Optional.of(Combinator.computeParameterCombinations(oldParameters, this.strengthA - 1));
        }
        if (strengthB > 0) {
            return Optional.of(Combinator.computeNegativeParameterCombinations(oldParameters, this.negativeParameters, this.strengthA, strengthB - 1));
        }
        return Optional.empty();
    }
}

