/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm;

import de.rwth.swc.coffee4j.algorithmic.sequential.generator.ipogneg.algorithm.ParameterOrder;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.stream.IntStream;

final class StrengthBasedParameterOrder
implements ParameterOrder {
    StrengthBasedParameterOrder() {
    }

    @Override
    public int[] getInitialParameters(Int2IntMap parameters, int strength) {
        Preconditions.notNull(parameters);
        Preconditions.check(strength >= 0);
        if (strength == 0) {
            return new int[0];
        }
        return IntStream.range(0, parameters.size()).boxed().sorted((first, second) -> Integer.compare(parameters.get(second.intValue()), parameters.get(first.intValue()))).limit(strength).mapToInt(i -> i).toArray();
    }

    @Override
    public int[] getRemainingParameters(Int2IntMap parameters, int strength) {
        return IntStream.range(0, parameters.size()).boxed().sorted((first, second) -> Integer.compare(parameters.get(second.intValue()), parameters.get(first.intValue()))).skip(strength).mapToInt(i -> i).toArray();
    }
}

