/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.manager;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.configuration.execution.ExecutionMode;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroup;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.prioritization.TestInputPrioritizer;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.EmptySequentialGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.GenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BasicSequentialCombinatorialTestManager
implements SequentialCombinatorialTestManager {
    private final SequentialCombinatorialTestConfiguration configuration;
    private final CompleteTestModel model;
    private final List<SingleGroupGenerationManager> managers = new ArrayList<SingleGroupGenerationManager>();

    public BasicSequentialCombinatorialTestManager(SequentialCombinatorialTestConfiguration configuration, CompleteTestModel model) {
        this.configuration = Preconditions.notNull(configuration);
        this.model = Preconditions.notNull(model);
    }

    @Override
    public List<int[]> generateInitialTests() {
        return this.configuration.getGenerators().stream().map(this::generateManagers).flatMap(Collection::stream).map(this::registerManager).map(SingleGroupGenerationManager::generateInitialTests).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Set<SingleGroupGenerationManager> generateManagers(TestInputGroupGenerator generator) {
        GenerationReporter generationReporter = this.configuration.getGenerationReporter().orElse(new EmptySequentialGenerationReporter());
        return generator.generate(this.model, generationReporter).stream().map(testInputGroupSupplier -> new SingleGroupGenerationManager((Supplier<TestInputGroup>)testInputGroupSupplier, generator, this.configuration.getPrioritizer(), this.configuration.getFaultCharacterizationAlgorithmFactory().orElse(null), generationReporter, this.configuration.getExecutionMode())).collect(Collectors.toSet());
    }

    private SingleGroupGenerationManager registerManager(SingleGroupGenerationManager manager) {
        this.managers.add(manager);
        return manager;
    }

    @Override
    public List<int[]> generateAdditionalTestInputsWithResult(int[] testInput, TestResult testResult) {
        IntArrayWrapper wrappedTestInputs = IntArrayWrapper.wrap(testInput);
        return this.managers.stream().map(manager -> manager.generateAdditionalTestInputsWithResult(wrappedTestInputs, testResult)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static final class SingleGroupGenerationManager {
        private final Supplier<TestInputGroup> testInputGroupSupplier;
        private final TestInputGroupGenerator testInputGroupGenerator;
        private final TestInputPrioritizer prioritizer;
        private final FaultCharacterizationAlgorithmFactory faultCharacterizationAlgorithmFactory;
        private final GenerationReporter reporter;
        private final boolean isFailFastExecutionMode;
        private TestInputGroup testInputGroup;
        private FaultCharacterizationAlgorithm faultCharacterizationAlgorithm;
        private Set<IntArrayWrapper> missingTestInputs;
        private Map<int[], TestResult> testResults;
        private boolean isInitialGeneration = true;

        private SingleGroupGenerationManager(Supplier<TestInputGroup> testInputGroupSupplier, TestInputGroupGenerator testInputGroupGenerator, TestInputPrioritizer prioritizer, FaultCharacterizationAlgorithmFactory faultCharacterizationAlgorithmFactory, GenerationReporter reporter, ExecutionMode executionMode) {
            this.testInputGroupSupplier = testInputGroupSupplier;
            this.testInputGroupGenerator = testInputGroupGenerator;
            this.prioritizer = prioritizer;
            this.faultCharacterizationAlgorithmFactory = faultCharacterizationAlgorithmFactory;
            this.reporter = reporter;
            this.isFailFastExecutionMode = executionMode == ExecutionMode.FAIL_FAST;
        }

        List<int[]> generateInitialTests() {
            this.testInputGroup = this.testInputGroupSupplier.get();
            this.reporter.testInputGroupGenerated(this.testInputGroup, this.testInputGroupGenerator);
            List<int[]> testInputs = this.testInputGroup.getTestInputs();
            List<int[]> prioritizedInputs = this.prioritizeInputsIfPossible(testInputs);
            this.initializeNextMissingTestInputs(prioritizedInputs);
            return prioritizedInputs;
        }

        private List<int[]> prioritizeInputsIfPossible(List<int[]> testInputs) {
            return this.testInputGroup.getFaultCharacterizationConfiguration().map(FaultCharacterizationConfiguration::getModel).map(testModel -> this.prioritizer.prioritize((Collection<int[]>)testInputs, (TestModel)testModel)).orElse(testInputs);
        }

        private void initializeNextMissingTestInputs(List<int[]> testInputs) {
            this.missingTestInputs = IntArrayWrapper.wrapToSet(testInputs);
            this.testResults = new HashMap<int[], TestResult>();
        }

        List<int[]> generateAdditionalTestInputsWithResult(IntArrayWrapper combination, TestResult testResult) {
            if (this.missingTestInputs.contains(combination)) {
                this.missingTestInputs.remove(combination);
                this.testResults.put(combination.getArray(), testResult);
                if (this.missingTestInputs.isEmpty() || testResult.isUnsuccessful() && this.isFailFastExecutionMode && this.isInitialGeneration) {
                    this.isInitialGeneration = false;
                    if (this.shouldUseFaultCharacterization()) {
                        return this.nextFaultCharacterizationIteration();
                    }
                    this.reporter.testInputGroupFinished(this.testInputGroup);
                }
            }
            return Collections.emptyList();
        }

        private boolean shouldUseFaultCharacterization() {
            return this.faultCharacterizationAlgorithm != null || this.faultCharacterizationAlgorithmFactory != null && this.testInputGroup.getFaultCharacterizationConfiguration().isPresent() && this.testResultsContainAnyFailure();
        }

        private boolean testResultsContainAnyFailure() {
            return this.testResults.values().stream().anyMatch(TestResult::isUnsuccessful);
        }

        private List<int[]> nextFaultCharacterizationIteration() {
            this.initializeCharacterizationAlgorithmIfNotInitialized();
            List<int[]> nextTestInputs = this.faultCharacterizationAlgorithm.computeNextTestInputs(new HashMap<int[], TestResult>(this.testResults));
            this.testResults.clear();
            if (nextTestInputs.isEmpty()) {
                List<int[]> failureInducingCombinations = this.faultCharacterizationAlgorithm.computeFailureInducingCombinations();
                this.reporter.faultCharacterizationFinished(this.testInputGroup, new HashMap<int[], Class<? extends Throwable>>(), new HashSet<int[]>(failureInducingCombinations));
                this.reporter.testInputGroupFinished(this.testInputGroup);
            } else {
                this.reporter.faultCharacterizationTestInputsGenerated(this.testInputGroup, nextTestInputs);
                this.missingTestInputs.addAll(IntArrayWrapper.wrapToSet(nextTestInputs));
            }
            return nextTestInputs;
        }

        private void initializeCharacterizationAlgorithmIfNotInitialized() {
            if (this.faultCharacterizationAlgorithm == null) {
                this.missingTestInputs.clear();
                FaultCharacterizationConfiguration configuration = this.testInputGroup.getFaultCharacterizationConfiguration().orElseThrow(() -> new IllegalArgumentException("Algorithm cannot be initialized without a configuration"));
                try {
                    this.faultCharacterizationAlgorithm = this.faultCharacterizationAlgorithmFactory.create(configuration);
                }
                catch (Exception e) {
                    throw new Coffee4JException(e, "Fault Characterization Algorithm could not be created!", new Object[0]);
                }
                this.reporter.faultCharacterizationStarted(this.testInputGroup, this.faultCharacterizationAlgorithm);
            }
        }
    }
}

