/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.manager;

import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.TestResultCache;
import de.rwth.swc.coffee4j.algorithmic.util.IntArrayWrapper;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CachingDelegatingSequentialCombinatorialTestManager
implements SequentialCombinatorialTestManager {
    private final TestResultCache cache;
    private final SequentialCombinatorialTestManager generator;
    private final Set<IntArrayWrapper> awaitedTestResults = new HashSet<IntArrayWrapper>();

    public CachingDelegatingSequentialCombinatorialTestManager(TestResultCache cache, SequentialCombinatorialTestManager generator) {
        this.cache = Preconditions.notNull(cache);
        this.generator = Preconditions.notNull(generator);
    }

    @Override
    public synchronized List<int[]> generateInitialTests() {
        return this.computeTestInputsWithUnknownResults(this.generator.generateInitialTests());
    }

    private List<int[]> computeTestInputsWithUnknownResults(List<int[]> neededTestResults) {
        ArrayList<int[]> testInputsWithUnknownResults = new ArrayList<int[]>();
        LinkedList remainingNeededTestResults = neededTestResults.stream().map(IntArrayWrapper::new).distinct().collect(Collectors.toCollection(LinkedList::new));
        while (!remainingNeededTestResults.isEmpty()) {
            IntArrayWrapper neededTestResult = (IntArrayWrapper)remainingNeededTestResults.poll();
            if (this.cache.containsResultFor(neededTestResult)) {
                TestResult testResult = this.cache.getResultFor(neededTestResult);
                this.generator.generateAdditionalTestInputsWithResult(neededTestResult.getArray(), testResult).stream().map(IntArrayWrapper::new).distinct().forEach(remainingNeededTestResults::push);
                continue;
            }
            if (this.awaitedTestResults.contains(neededTestResult)) continue;
            testInputsWithUnknownResults.add(neededTestResult.getArray());
            this.awaitedTestResults.add(neededTestResult);
        }
        return testInputsWithUnknownResults;
    }

    @Override
    public synchronized List<int[]> generateAdditionalTestInputsWithResult(int[] testInput, TestResult testResult) {
        IntArrayWrapper wrappedTestInput = IntArrayWrapper.wrap(testInput);
        this.awaitedTestResults.remove(wrappedTestInput);
        this.cache.addResultFor(wrappedTestInput, testResult);
        return this.computeTestInputsWithUnknownResults(this.generator.generateAdditionalTestInputsWithResult(testInput, testResult));
    }

    public SequentialCombinatorialTestManager getGenerator() {
        return this.generator;
    }
}

