/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.manager;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.MinimalForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.model.CompleteTestModel;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.GeneratingFaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.mixtgte.Mixtgte;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroup;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.emptyset.EmptySetGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.GeneratingSequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.EmptySequentialGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.GenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ConstraintGeneratingSequentialCombinatorialTestManager
implements GeneratingSequentialCombinatorialTestManager {
    private final TestInputGroup testInputGroup;
    private final GenerationReporter generationReporter;
    private final GeneratingFaultCharacterizationAlgorithm faultCharacterizationAlgorithm;
    private final ClassificationStrategy classificationStrategy;
    private Set<IntList> missingTestInputs;
    private Map<int[], TestResult> testResults;

    public ConstraintGeneratingSequentialCombinatorialTestManager(SequentialCombinatorialTestConfiguration configuration, CompleteTestModel testModel) {
        Preconditions.notNull(configuration);
        Preconditions.notNull(testModel);
        this.generationReporter = configuration.getGenerationReporter().orElseGet(EmptySequentialGenerationReporter::new);
        FaultCharacterizationAlgorithmFactory faultCharacterizationAlgorithmFactory = configuration.getFaultCharacterizationAlgorithmFactory().orElse(null);
        if (faultCharacterizationAlgorithmFactory == null) {
            throw new Coffee4JException("No Fault Characterization Factory available!");
        }
        Optional optionalGenerator = configuration.getGenerators().stream().findFirst();
        TestInputGroupGenerator testInputGroupGenerator = optionalGenerator.orElse(new EmptySetGenerator());
        Collection<Supplier<TestInputGroup>> testInputGroupSupplier = testInputGroupGenerator.generate(testModel, this.generationReporter);
        Optional<Supplier<TestInputGroup>> optGroupSupplier = testInputGroupSupplier.stream().findFirst();
        assert (testInputGroupSupplier.size() == 1);
        this.testInputGroup = optGroupSupplier.get().get();
        this.generationReporter.testInputGroupGenerated(this.testInputGroup, testInputGroupGenerator);
        FaultCharacterizationConfiguration faultCharacterizationConfiguration = this.testInputGroup.getFaultCharacterizationConfiguration().orElse(new FaultCharacterizationConfiguration(testModel, this.generationReporter));
        try {
            this.faultCharacterizationAlgorithm = (GeneratingFaultCharacterizationAlgorithm)faultCharacterizationAlgorithmFactory.create(faultCharacterizationConfiguration);
        }
        catch (Exception e) {
            throw new Coffee4JException(e, "Generating Fault Characterization Algorithm could not be created!", new Object[0]);
        }
        if (!configuration.getClassificationStrategyFactory().isPresent()) {
            throw new Coffee4JException("No Classification-Strategy provided!");
        }
        Optional<ClassificationStrategyFactory> optFactory = configuration.getClassificationStrategyFactory();
        this.classificationStrategy = Preconditions.notNull(optFactory.get()).create(ClassificationConfiguration.configuration().constraintChecker(MinimalForbiddenTuplesChecker.minimalForbiddenTuplesChecker().createConstraintChecker(testModel)).testModel(testModel).build());
    }

    @Override
    public List<int[]> generateInitialTests() {
        ArrayList<int[]> initialTestSuite = new ArrayList<int[]>();
        if (!(this.faultCharacterizationAlgorithm instanceof Mixtgte)) {
            initialTestSuite.addAll(this.testInputGroup.getTestInputs());
        }
        if (initialTestSuite.isEmpty()) {
            initialTestSuite = this.faultCharacterizationAlgorithm.computeNextTestInputs(new HashMap<int[], TestResult>());
        }
        this.missingTestInputs = initialTestSuite.stream().map(IntArrayList::new).collect(Collectors.toSet());
        this.testResults = new HashMap<int[], TestResult>();
        this.generationReporter.faultCharacterizationStarted(this.testInputGroup, this.faultCharacterizationAlgorithm);
        return initialTestSuite;
    }

    @Override
    public List<int[]> generateAdditionalTestInputsWithResult(int[] testInput, TestResult testResult) {
        IntArrayList input = new IntArrayList(testInput);
        if (this.missingTestInputs.contains(input)) {
            this.missingTestInputs.remove(input);
            this.testResults.put(testInput, testResult);
            if (this.missingTestInputs.isEmpty()) {
                List<int[]> nextTestInputs = this.faultCharacterizationAlgorithm.computeNextTestInputs(new HashMap<int[], TestResult>(this.testResults));
                this.testResults.clear();
                if (!nextTestInputs.isEmpty()) {
                    this.generationReporter.faultCharacterizationTestInputsGenerated(this.testInputGroup, nextTestInputs);
                    this.missingTestInputs.addAll(nextTestInputs.stream().map(IntArrayList::new).collect(Collectors.toList()));
                }
                return nextTestInputs;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<int[]> initializeClassification(Map<int[], TestResult> errorConstraintExceptionCausingTestInputs) {
        Optional<int[]> nextTestInput = this.classificationStrategy.startClassification(errorConstraintExceptionCausingTestInputs.entrySet().stream().map(input -> Map.entry((int[])input.getKey(), ((TestResult)input.getValue()).getResultValue().get().getCause())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), new ArrayList<int[]>(this.faultCharacterizationAlgorithm.computeExceptionInducingCombinations()), new HashSet<int[]>(this.faultCharacterizationAlgorithm.computeFailureInducingCombinations()));
        return this.checkTestInputForClassification(nextTestInput);
    }

    @Override
    public Optional<int[]> generateNextTestInputForClassification(int[] testInput, TestResult testResult) {
        Optional<int[]> nextTestInput = this.classificationStrategy.generateNextTestInputForClassification(testInput, testResult);
        return this.checkTestInputForClassification(nextTestInput);
    }

    private Optional<int[]> checkTestInputForClassification(Optional<int[]> nextTestInput) {
        if (!nextTestInput.isPresent()) {
            List<int[]> failureInducingCombinations = this.faultCharacterizationAlgorithm.computeFailureInducingCombinations();
            Map<int[], Class<? extends Throwable>> exceptionInducingCombinations = this.classificationStrategy.getClassifiedExceptionInducingCombinations();
            this.generationReporter.faultCharacterizationFinished(this.testInputGroup, exceptionInducingCombinations, new HashSet<int[]>(failureInducingCombinations));
            this.generationReporter.testInputGroupFinished(this.testInputGroup);
        }
        return nextTestInput;
    }

    public Set<IntList> getMinimalExceptionInducingTuples() {
        return this.classificationStrategy.getClassifiedExceptionInducingCombinations().keySet().stream().map(IntArrayList::new).collect(Collectors.toSet());
    }
}

