/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.sequential.manager;

import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.configuration.execution.ExecutionMode;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.prioritization.NoOpTestInputPrioritizer;
import de.rwth.swc.coffee4j.algorithmic.sequential.prioritization.TestInputPrioritizer;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.GenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SequentialCombinatorialTestConfiguration {
    private final FaultCharacterizationAlgorithmFactory faultCharacterizationAlgorithmFactory;
    private final ClassificationStrategyFactory classificationStrategyFactory;
    private final List<TestInputGroupGenerator> generators;
    private final TestInputPrioritizer prioritizer;
    private final GenerationReporter generationReporter;
    private final ExecutionMode executionMode;

    public SequentialCombinatorialTestConfiguration(FaultCharacterizationAlgorithmFactory faultCharacterizationAlgorithmFactory, ClassificationStrategyFactory classificationStrategyFactory, Collection<TestInputGroupGenerator> generators, TestInputPrioritizer prioritizer, GenerationReporter generationReporter, ExecutionMode executionMode) {
        Preconditions.notNull(generators);
        this.faultCharacterizationAlgorithmFactory = faultCharacterizationAlgorithmFactory;
        this.classificationStrategyFactory = classificationStrategyFactory;
        this.generators = new ArrayList<TestInputGroupGenerator>(generators);
        this.prioritizer = prioritizer == null ? new NoOpTestInputPrioritizer() : prioritizer;
        this.generationReporter = generationReporter;
        this.executionMode = executionMode == null ? ExecutionMode.EXECUTE_ALL : executionMode;
    }

    public Optional<FaultCharacterizationAlgorithmFactory> getFaultCharacterizationAlgorithmFactory() {
        return Optional.ofNullable(this.faultCharacterizationAlgorithmFactory);
    }

    public Optional<ClassificationStrategyFactory> getClassificationStrategyFactory() {
        return Optional.ofNullable(this.classificationStrategyFactory);
    }

    public List<TestInputGroupGenerator> getGenerators() {
        return Collections.unmodifiableList(this.generators);
    }

    public TestInputPrioritizer getPrioritizer() {
        return this.prioritizer;
    }

    public Optional<GenerationReporter> getGenerationReporter() {
        return Optional.ofNullable(this.generationReporter);
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SequentialCombinatorialTestConfiguration other = (SequentialCombinatorialTestConfiguration)object;
        return Objects.equals(this.faultCharacterizationAlgorithmFactory, other.faultCharacterizationAlgorithmFactory) && this.classificationStrategyFactory.equals(other.classificationStrategyFactory) && this.generators.equals(other.generators) && this.prioritizer.equals(other.prioritizer) && this.generationReporter.equals(other.generationReporter) && this.executionMode.equals((Object)other.executionMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.faultCharacterizationAlgorithmFactory, this.classificationStrategyFactory, this.generators, this.prioritizer, this.generationReporter, this.executionMode});
    }

    public String toString() {
        return "CombinatorialTestConfiguration{faultCharacterizationAlgorithmFactory=" + this.faultCharacterizationAlgorithmFactory + "classificationStrategyFactory=" + this.classificationStrategyFactory + ", generators=" + this.generators + ", prioritizer=" + this.prioritizer + ", generationReporter=" + this.generationReporter + ", executionMode=" + this.executionMode + "}";
    }
}

