/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.util;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.OptionalInt;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static int[] exclude(int[] elements, int[] excludedElements) {
        Preconditions.notNull(elements);
        Preconditions.notNull(excludedElements);
        int[] elementsWithoutExcluded = new int[elements.length - ArrayUtil.numberOfOccurrences(elements, excludedElements)];
        int index = 0;
        for (int element : elements) {
            if (ArrayUtil.contains(excludedElements, element)) continue;
            elementsWithoutExcluded[index++] = element;
        }
        return elementsWithoutExcluded;
    }

    private static int numberOfOccurrences(int[] elements, int[] otherElements) {
        int occurrences = 0;
        for (int element : elements) {
            if (!ArrayUtil.contains(otherElements, element)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static boolean contains(int[] elements, int element) {
        Preconditions.notNull(elements);
        for (int leftElement : elements) {
            if (leftElement != element) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(int[] elements, int[] otherElements) {
        Preconditions.notNull(elements);
        Preconditions.notNull(otherElements);
        if (otherElements.length > elements.length) {
            return false;
        }
        for (int otherElement : otherElements) {
            if (ArrayUtil.contains(elements, otherElement)) continue;
            return false;
        }
        return true;
    }

    public static OptionalInt indexOf(int[] elements, int element) {
        Preconditions.notNull(elements);
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != element) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static boolean containsDuplicates(int[] elements) {
        Preconditions.notNull(elements);
        IntArraySet set = new IntArraySet();
        for (int element : elements) {
            if (set.add(element)) continue;
            return true;
        }
        return false;
    }
}

