/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.util;

import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintChecker;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;

public final class CombinationUtil {
    public static final int NO_VALUE = -1;

    private CombinationUtil() {
    }

    public static int[] emptyCombination(int size) {
        Preconditions.check(size >= 0);
        int[] combination = new int[size];
        Arrays.fill(combination, -1);
        return combination;
    }

    public static boolean contains(int[] firstCombination, int[] secondCombination) {
        CombinationUtil.checkNotNullAndSameLength(firstCombination, secondCombination);
        for (int i = 0; i < firstCombination.length; ++i) {
            if (secondCombination[i] == -1 || firstCombination[i] == secondCombination[i]) continue;
            return false;
        }
        return true;
    }

    private static void checkNotNullAndSameLength(int[] first, int[] second) {
        Preconditions.notNull(first);
        Preconditions.notNull(second);
        Preconditions.check(first.length == second.length);
    }

    public static boolean canBeAdded(int[] combination, int[] toBeAdded, ConstraintChecker constraintChecker) {
        Preconditions.notNull(constraintChecker);
        CombinationUtil.checkNotNullAndSameLength(combination, toBeAdded);
        for (int i = 0; i < toBeAdded.length; ++i) {
            if (toBeAdded[i] == -1 || combination[i] == -1 || combination[i] == toBeAdded[i]) continue;
            return false;
        }
        TIntArrayList dual = new TIntArrayList();
        for (int i = 0; i < toBeAdded.length; ++i) {
            if (toBeAdded[i] == -1) continue;
            dual.add(i);
            dual.add(toBeAdded[i]);
        }
        return constraintChecker.isExtensionValid(combination, dual.toArray());
    }

    public static void add(int[] combination, int[] toBeAdded) {
        CombinationUtil.checkNotNullAndSameLength(combination, toBeAdded);
        for (int i = 0; i < toBeAdded.length; ++i) {
            if (toBeAdded[i] == -1) continue;
            combination[i] = toBeAdded[i];
        }
    }

    public static boolean containsAllParameters(int[] combination, IntSet parameterIndices) {
        Preconditions.notNull(combination);
        Preconditions.notNull(parameterIndices);
        IntIterator intIterator = parameterIndices.iterator();
        while (intIterator.hasNext()) {
            int parameterIndex = (Integer)intIterator.next();
            if (parameterIndex >= 0 && parameterIndex < combination.length && combination[parameterIndex] != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllParameters(int[] combination, int untilParameter) {
        Preconditions.notNull(combination);
        if (untilParameter >= combination.length) {
            return false;
        }
        for (int parameter = 0; parameter <= untilParameter; ++parameter) {
            if (combination[parameter] != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean sameForAllGivenParameters(int[] first, int[] second, IntSet parameters) {
        CombinationUtil.checkNotNullAndSameLength(first, second);
        Preconditions.notNull(parameters);
        IntIterator intIterator = parameters.iterator();
        while (intIterator.hasNext()) {
            int parameter = (Integer)intIterator.next();
            if (parameter < 0 || parameter >= first.length || first[parameter] == second[parameter]) continue;
            return false;
        }
        return true;
    }

    public static int numberOfSetParameters(int[] combination) {
        Preconditions.notNull(combination);
        int numberOfSetParameters = 0;
        for (int value : combination) {
            if (value == -1) continue;
            ++numberOfSetParameters;
        }
        return numberOfSetParameters;
    }
}

