/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.util;

import de.rwth.swc.coffee4j.algorithmic.util.ArrayUtil;
import de.rwth.swc.coffee4j.algorithmic.util.CombinationUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;

public final class Combinator {
    private static final String PARAMETERS_NOT_NULL = "Parameters cannot be null";
    private static final String AT_LEAST_ONE_PARAMETER = "At least one parameter has to be given";
    private static final String TOO_MANY_PARAMETERS = "The combination size cannot be smaller than the numberof parameters";
    private static final String TOO_HIGH_PARAMETERS = "The combination size cannot be smaller than the highestparameter number";
    private static final String SIZE_NOT_NEGATIVE = "The size of combinations cannot be negative";

    private Combinator() {
    }

    public static List<int[]> computeCartesianProduct(Int2IntMap parameters, int combinationSize) {
        Preconditions.notNull(parameters, PARAMETERS_NOT_NULL);
        Preconditions.check(!parameters.isEmpty(), AT_LEAST_ONE_PARAMETER);
        Preconditions.check(combinationSize >= parameters.size(), TOO_MANY_PARAMETERS);
        Preconditions.check(combinationSize > parameters.keySet().stream().mapToInt(parameter -> parameter).max().orElse(0), TOO_HIGH_PARAMETERS);
        ArrayList<int[]> combinations = new ArrayList<int[]>();
        int[] currentIndex = new int[parameters.size()];
        int[] keys = parameters.keySet().toIntArray();
        Arrays.sort(keys);
        do {
            int[] currentCombination = new int[combinationSize];
            Arrays.fill(currentCombination, -1);
            for (int i = 0; i < keys.length; ++i) {
                int value;
                int index = keys[i];
                currentCombination[index] = value = currentIndex[i];
            }
            combinations.add(currentCombination);
        } while (Combinator.tryIncreaseByOne(currentIndex, keys, parameters));
        return combinations;
    }

    private static boolean tryIncreaseByOne(int[] currentIndex, int[] keys, Int2IntMap parameters) {
        for (int i = 0; i < currentIndex.length; ++i) {
            int n = i;
            currentIndex[n] = currentIndex[n] + 1;
            if (currentIndex[i] < parameters.get(keys[i])) {
                return true;
            }
            currentIndex[i] = 0;
        }
        return false;
    }

    public static List<IntSet> computeParameterCombinations(int[] parameters, int size) {
        Preconditions.notNull(parameters, PARAMETERS_NOT_NULL);
        Preconditions.check(size >= 0, SIZE_NOT_NEGATIVE);
        return Combinator.computeParameterCombinationsRecursively(parameters, size);
    }

    private static List<IntSet> computeParameterCombinationsRecursively(int[] parameters, int k) {
        if (k == 0 || parameters.length == 0 || parameters.length < k) {
            return Collections.emptyList();
        }
        if (k == 1) {
            ArrayList<IntSet> combinations = new ArrayList<IntSet>(parameters.length);
            for (int parameter : parameters) {
                IntOpenHashSet set = new IntOpenHashSet(1);
                set.add(parameter);
                combinations.add((IntSet)set);
            }
            return combinations;
        }
        if (parameters.length == k) {
            ArrayList<IntSet> combinations = new ArrayList<IntSet>(1);
            combinations.add((IntSet)new IntOpenHashSet(parameters));
            return combinations;
        }
        int[] tail = Arrays.copyOfRange(parameters, 1, parameters.length);
        List<IntSet> tailSubsets = Combinator.computeParameterCombinationsRecursively(tail, k - 1);
        for (IntSet set : tailSubsets) {
            set.add(parameters[0]);
        }
        List<IntSet> subsets = Combinator.computeParameterCombinationsRecursively(tail, k);
        ArrayList<IntSet> combinations = new ArrayList<IntSet>(tailSubsets.size() + subsets.size());
        combinations.addAll(tailSubsets);
        combinations.addAll(subsets);
        return combinations;
    }

    public static List<IntSet> computeNegativeParameterCombinations(int[] parameters, int[] negativeParameters, int strengthA, int strengthB) {
        Preconditions.notNull(parameters);
        Preconditions.notNull(negativeParameters);
        Preconditions.check(ArrayUtil.containsAll(parameters, negativeParameters));
        Preconditions.check(strengthA > 0 && strengthA <= negativeParameters.length);
        Preconditions.check(strengthB >= 0);
        List<IntSet> errorTupleInteractions = Combinator.computeParameterCombinations(negativeParameters, strengthA);
        if (strengthB == 0) {
            return errorTupleInteractions;
        }
        int[] otherParameters = ArrayUtil.exclude(parameters, negativeParameters);
        List<IntSet> remainingInteractions = Combinator.computeParameterCombinations(otherParameters, Math.min(strengthB, otherParameters.length));
        return Combinator.unionElementWise(errorTupleInteractions, remainingInteractions);
    }

    private static List<IntSet> unionElementWise(List<IntSet> first, List<IntSet> second) {
        Preconditions.notNull(first);
        Preconditions.notNull(second);
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ArrayList<IntSet> allUnions = new ArrayList<IntSet>(first.size() * second.size());
        for (IntSet firstElement : first) {
            for (IntSet secondElement : second) {
                IntArraySet union = new IntArraySet((IntCollection)firstElement);
                union.addAll((IntCollection)secondElement);
                allUnions.add((IntSet)union);
            }
        }
        return allUnions;
    }

    public static Set<int[]> computeCombinations(int[] parameterSizes, IntSet parameters) {
        Preconditions.notNull(parameterSizes, "parameter sizes required");
        Preconditions.notNull(parameters, "parameters required");
        Preconditions.check(parameterSizes.length > 0, "At least one parameter required");
        Preconditions.check(!parameters.isEmpty(), "At least one parameter required");
        Preconditions.check(parameters.stream().allMatch(parameter -> parameter >= 0 && parameter < parameterSizes.length), "invalid parameter in " + parameters + " for sizes " + Arrays.toString(parameterSizes));
        return Combinator.computeCombinationsRecursively(parameterSizes, parameters.toIntArray(), CombinationUtil.emptyCombination(parameterSizes.length), 0);
    }

    private static Set<int[]> computeCombinationsRecursively(int[] parameterSizes, int[] parameterIndices, int[] currentCombination, int currentIndex) {
        boolean isLastIteration = currentIndex == parameterIndices.length - 1;
        int parameter = parameterIndices[currentIndex];
        int parameterSize = parameterSizes[parameter];
        HashSet<int[]> combinations = new HashSet<int[]>();
        for (int value = 0; value < parameterSize; ++value) {
            int[] currentCombinationWithValue = Arrays.copyOf(currentCombination, currentCombination.length);
            currentCombinationWithValue[parameter] = value;
            if (isLastIteration) {
                combinations.add(currentCombinationWithValue);
                continue;
            }
            combinations.addAll(Combinator.computeCombinationsRecursively(parameterSizes, parameterIndices, currentCombinationWithValue, currentIndex + 1));
        }
        return combinations;
    }

    public static Set<int[]> computeCombinations(int[] parameters, int size) {
        Preconditions.notNull(parameters);
        Preconditions.check(size >= 0);
        List<IntSet> parameterCombinations = Combinator.computeParameterCombinationsRecursively(IntStream.range(0, parameters.length).toArray(), size);
        HashSet<int[]> combinations = new HashSet<int[]>();
        for (IntSet parameterCombination : parameterCombinations) {
            Int2IntOpenHashMap parameterSizes = new Int2IntOpenHashMap(parameterCombination.size());
            IntIterator intIterator = parameterCombination.iterator();
            while (intIterator.hasNext()) {
                int parameter = (Integer)intIterator.next();
                parameterSizes.put(parameter, parameters[parameter]);
            }
            combinations.addAll(Combinator.computeCartesianProduct((Int2IntMap)parameterSizes, parameters.length));
        }
        return combinations;
    }

    public static List<int[]> computeSubCombinations(int[] combination, int size) {
        Preconditions.notNull(combination);
        Preconditions.check(size >= 0);
        return Combinator.computeSubCombinationsRecursively(combination, CombinationUtil.emptyCombination(combination.length), 0, size);
    }

    private static List<int[]> computeSubCombinationsRecursively(int[] combination, int[] currentSubCombination, int index, int size) {
        int currentSize = CombinationUtil.numberOfSetParameters(currentSubCombination);
        if (currentSize == size) {
            return Collections.singletonList(Arrays.copyOf(currentSubCombination, currentSubCombination.length));
        }
        if (index == combination.length || size > combination.length - index + 1 + currentSize) {
            return Collections.emptyList();
        }
        ArrayList<int[]> result = new ArrayList<int[]>(Combinator.computeSubCombinationsRecursively(combination, currentSubCombination, index + 1, size));
        if (combination[index] != -1) {
            currentSubCombination[index] = combination[index];
            result.addAll(Combinator.computeSubCombinationsRecursively(combination, currentSubCombination, index + 1, size));
            currentSubCombination[index] = -1;
        }
        return result;
    }

    public static List<int[]> computeSubCombinations(int[] combination) {
        Preconditions.notNull(combination);
        return Combinator.computeSubCombinationsRecursively(combination, CombinationUtil.emptyCombination(combination.length), 0);
    }

    private static List<int[]> computeSubCombinationsRecursively(int[] combination, int[] currentSubCombination, int index) {
        if (index == combination.length) {
            if (CombinationUtil.numberOfSetParameters(currentSubCombination) > 0) {
                return Collections.singletonList(Arrays.copyOf(currentSubCombination, currentSubCombination.length));
            }
            return Collections.emptyList();
        }
        ArrayList<int[]> result = new ArrayList<int[]>(Combinator.computeSubCombinationsRecursively(combination, currentSubCombination, index + 1));
        if (combination[index] != -1) {
            currentSubCombination[index] = combination[index];
            result.addAll(Combinator.computeSubCombinationsRecursively(combination, currentSubCombination, index + 1));
            currentSubCombination[index] = -1;
        }
        return result;
    }
}

