/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IntArrayWrapper {
    private final int[] array;

    public IntArrayWrapper(int[] array) {
        this.array = array;
    }

    public int[] getArray() {
        return this.array;
    }

    public static IntArrayWrapper wrap(int ... array) {
        return new IntArrayWrapper(array);
    }

    public static List<IntArrayWrapper> wrapToList(Collection<int[]> arrays) {
        ArrayList<IntArrayWrapper> wrappers = new ArrayList<IntArrayWrapper>(arrays.size());
        IntArrayWrapper.wrapAll(wrappers, arrays);
        return wrappers;
    }

    private static void wrapAll(Collection<IntArrayWrapper> wrapped, Collection<int[]> arrays) {
        for (int[] array : arrays) {
            wrapped.add(IntArrayWrapper.wrap(array));
        }
    }

    public static Set<IntArrayWrapper> wrapToSet(Collection<int[]> arrays) {
        HashSet<IntArrayWrapper> wrappers = new HashSet<IntArrayWrapper>(arrays.size());
        IntArrayWrapper.wrapAll(wrappers, arrays);
        return wrappers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayWrapper that = (IntArrayWrapper)o;
        return Arrays.equals(this.array, that.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

