/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.util;

import java.util.Collection;
import java.util.function.Supplier;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T notNull(T object) {
        return Preconditions.notNull(object, "Object must not be null");
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static <T> T notNull(T object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new NullPointerException(messageSupplier.get());
        }
        return object;
    }

    public static <T> Collection<T> doesNotContainNull(Collection<T> collection) {
        return Preconditions.doesNotContainNull(collection, "The collection must not contain null");
    }

    public static <T> Collection<T> doesNotContainNull(Collection<T> collection, String message) {
        if (collection.contains(null)) {
            throw new IllegalArgumentException(message);
        }
        return collection;
    }

    public static <T> Collection<T> doesNotContainNull(Collection<T> collection, Supplier<String> messageSupplier) {
        if (collection.contains(null)) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        return collection;
    }

    public static void check(boolean expression) {
        Preconditions.check(expression, "The expression must not evaluate to false");
    }

    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }
}

