/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.algorithmic.util;

import de.rwth.swc.coffee4j.algorithmic.util.ArrayUtil;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import java.util.OptionalInt;

public final class TupleUtil {
    private TupleUtil() {
    }

    public static boolean tuplesAreEqual(int[] parameters, int[] values, int[] otherParameters, int[] otherValues) {
        Preconditions.notNull(parameters);
        Preconditions.check(!ArrayUtil.containsDuplicates(parameters));
        Preconditions.notNull(values);
        Preconditions.check(parameters.length == values.length);
        Preconditions.notNull(otherParameters);
        Preconditions.check(!ArrayUtil.containsDuplicates(otherParameters));
        Preconditions.notNull(otherValues);
        Preconditions.check(otherParameters.length == otherValues.length);
        if (parameters.length != otherParameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            int parameter = parameters[i];
            int value = values[i];
            OptionalInt indexOfOtherParameter = ArrayUtil.indexOf(otherParameters, parameter);
            if (!indexOfOtherParameter.isPresent()) {
                return false;
            }
            int otherValue = otherValues[indexOfOtherParameter.getAsInt()];
            if (value == otherValue) continue;
            return false;
        }
        return true;
    }
}

