/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.execution;

import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.classification.NoOpClassificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.configuration.execution.ExecutionMode;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictDetectionConfiguration;
import de.rwth.swc.coffee4j.algorithmic.constraint.ConstraintCheckerFactory;
import de.rwth.swc.coffee4j.algorithmic.constraint.MinimalForbiddenTuplesChecker;
import de.rwth.swc.coffee4j.algorithmic.interleaving.feedback.FeedbackCheckingStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.generator.TestInputGenerationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.identification.IdentificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.DefaultGeneratingInterleavingManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.DefaultInterleavingManager;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.GeneratingInterleavingManagerFactory;
import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingManagerFactory;
import de.rwth.swc.coffee4j.algorithmic.report.ArgumentConverter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.Buildable;
import de.rwth.swc.coffee4j.engine.converter.model.IndexBasedModelConverter;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverterFactory;
import de.rwth.swc.coffee4j.engine.report.InterleavingExecutionReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class InterleavingExecutionConfiguration {
    protected final InterleavingManagerFactory managerFactory;
    private final ModelConverterFactory modelConverterFactory;
    private final ConflictDetectionConfiguration conflictDetectionConfiguration;
    private final TestInputGenerationStrategyFactory testInputGenerationStrategyFactory;
    private final IdentificationStrategyFactory identificationStrategyFactory;
    private final FeedbackCheckingStrategyFactory feedbackCheckingStrategyFactory;
    private final ClassificationStrategyFactory classificationStrategyFactory;
    private final ConstraintCheckerFactory constraintCheckerFactory;
    private final List<InterleavingExecutionReporter> executionReporters;
    private final List<ArgumentConverter> argumentConverters;
    private final ExecutionMode executionMode;
    private final boolean isGenerating;

    InterleavingExecutionConfiguration(Builder builder) {
        Preconditions.notNull((Object)builder.managerFactory);
        Preconditions.notNull((Object)builder.modelConverterFactory);
        Preconditions.notNull((Object)builder.conflictDetectionConfiguration);
        Preconditions.notNull((Object)builder.testInputGenerationStrategyFactory);
        Preconditions.notNull((Object)builder.identificationStrategyFactory);
        Preconditions.notNull((Object)builder.feedbackCheckingStrategyFactory);
        Preconditions.notNull((Object)builder.classificationStrategyFactory);
        Preconditions.notNull((Object)builder.executionMode);
        Preconditions.check((!builder.isGenerating || builder.managerFactory instanceof GeneratingInterleavingManagerFactory ? 1 : 0) != 0);
        this.managerFactory = builder.managerFactory;
        this.modelConverterFactory = builder.modelConverterFactory;
        this.conflictDetectionConfiguration = builder.conflictDetectionConfiguration;
        this.testInputGenerationStrategyFactory = builder.testInputGenerationStrategyFactory;
        this.identificationStrategyFactory = builder.identificationStrategyFactory;
        this.feedbackCheckingStrategyFactory = builder.feedbackCheckingStrategyFactory;
        this.classificationStrategyFactory = builder.classificationStrategyFactory;
        this.constraintCheckerFactory = builder.constraintCheckerFactory;
        this.executionReporters = new ArrayList<InterleavingExecutionReporter>(builder.executionReporters);
        this.argumentConverters = new ArrayList<ArgumentConverter>(builder.argumentConverters);
        this.executionMode = builder.executionMode;
        this.isGenerating = builder.isGenerating;
    }

    public InterleavingManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public ModelConverterFactory getModelConverterFactory() {
        return this.modelConverterFactory;
    }

    public ConflictDetectionConfiguration getConflictDetectionConfiguration() {
        return this.conflictDetectionConfiguration;
    }

    public TestInputGenerationStrategyFactory getTestInputGenerationStrategyFactory() {
        return this.testInputGenerationStrategyFactory;
    }

    public IdentificationStrategyFactory getIdentificationStrategyFactory() {
        return this.identificationStrategyFactory;
    }

    public FeedbackCheckingStrategyFactory getFeedbackCheckingStrategyFactory() {
        return this.feedbackCheckingStrategyFactory;
    }

    public ClassificationStrategyFactory getClassificationStrategyFactory() {
        return this.classificationStrategyFactory;
    }

    public ConstraintCheckerFactory getConstraintCheckerFactory() {
        return this.constraintCheckerFactory;
    }

    public List<InterleavingExecutionReporter> getExecutionReporters() {
        return this.executionReporters;
    }

    public List<ArgumentConverter> getArgumentConverters() {
        return this.argumentConverters;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InterleavingExecutionConfiguration)) {
            return false;
        }
        InterleavingExecutionConfiguration other = (InterleavingExecutionConfiguration)object;
        return Objects.equals(this.modelConverterFactory, other.modelConverterFactory) && Objects.equals(this.conflictDetectionConfiguration, other.conflictDetectionConfiguration) && Objects.equals(this.testInputGenerationStrategyFactory, other.testInputGenerationStrategyFactory) && Objects.equals(this.identificationStrategyFactory, other.identificationStrategyFactory) && Objects.equals(this.feedbackCheckingStrategyFactory, other.feedbackCheckingStrategyFactory) && Objects.equals(this.classificationStrategyFactory, other.classificationStrategyFactory) && Objects.equals(this.constraintCheckerFactory, other.constraintCheckerFactory) && Objects.equals(this.executionReporters, other.executionReporters) && Objects.equals(this.argumentConverters, other.argumentConverters) && Objects.equals(this.executionMode, other.executionMode) && Objects.equals(this.isGenerating, other.isGenerating);
    }

    public int hashCode() {
        return Objects.hash(this.managerFactory, this.modelConverterFactory, this.conflictDetectionConfiguration, this.testInputGenerationStrategyFactory, this.identificationStrategyFactory, this.feedbackCheckingStrategyFactory, this.classificationStrategyFactory, this.constraintCheckerFactory, this.executionReporters, this.argumentConverters, this.executionMode, this.isGenerating);
    }

    public String toString() {
        return "InterleavingExecutionConfiguration{managerFactory=" + this.managerFactory + ", modelConverterFactory=" + this.modelConverterFactory + ", conflictDetectionConfiguration=" + this.conflictDetectionConfiguration + ", testInputGenerationStrategyFactory=" + this.testInputGenerationStrategyFactory + ", identificationStrategyFactory=" + this.identificationStrategyFactory + ", feedbackCheckingStrategyFactory=" + this.feedbackCheckingStrategyFactory + ", classificationStrategyFactory=" + this.classificationStrategyFactory + ", constraintCheckerFactory=" + this.constraintCheckerFactory + ", executionReporters=" + this.executionReporters + ", argumentConverters=" + this.argumentConverters + ", executionMode=" + this.executionMode + ", isGenerating=" + this.isGenerating + "}";
    }

    public static Builder executionConfiguration() {
        return new Builder().managerFactory((InterleavingManagerFactory)DefaultInterleavingManager.managerFactory()).isGenerating(false);
    }

    public static Builder generatingExecutionConfiguration() {
        return InterleavingExecutionConfiguration.executionConfiguration().managerFactory((InterleavingManagerFactory)DefaultGeneratingInterleavingManager.managerFactory()).isGenerating(true);
    }

    public static class Builder
    implements Buildable<InterleavingExecutionConfiguration> {
        protected InterleavingManagerFactory managerFactory;
        private ModelConverterFactory modelConverterFactory = IndexBasedModelConverter::new;
        private ConflictDetectionConfiguration conflictDetectionConfiguration = ConflictDetectionConfiguration.disable();
        private TestInputGenerationStrategyFactory testInputGenerationStrategyFactory;
        private IdentificationStrategyFactory identificationStrategyFactory;
        private FeedbackCheckingStrategyFactory feedbackCheckingStrategyFactory;
        private ClassificationStrategyFactory classificationStrategyFactory = NoOpClassificationStrategy.noOpClassificationStrategy();
        private ConstraintCheckerFactory constraintCheckerFactory = MinimalForbiddenTuplesChecker.minimalForbiddenTuplesChecker();
        private final List<InterleavingExecutionReporter> executionReporters = new ArrayList<InterleavingExecutionReporter>();
        private final List<ArgumentConverter> argumentConverters = new ArrayList<ArgumentConverter>();
        private ExecutionMode executionMode = ExecutionMode.EXECUTE_ALL;
        private boolean isGenerating;

        public Builder managerFactory(InterleavingManagerFactory managerFactory) {
            this.managerFactory = managerFactory;
            return this;
        }

        public Builder modelConverterFactory(ModelConverterFactory modelConverterFactory) {
            this.modelConverterFactory = modelConverterFactory;
            return this;
        }

        public Builder conflictDetectionConfiguration(ConflictDetectionConfiguration conflictDetectionConfiguration) {
            this.conflictDetectionConfiguration = conflictDetectionConfiguration;
            return this;
        }

        public Builder testInputGenerationStrategyFactory(TestInputGenerationStrategyFactory testInputGenerationStrategyFactory) {
            this.testInputGenerationStrategyFactory = testInputGenerationStrategyFactory;
            return this;
        }

        public Builder identificationStrategyFactory(IdentificationStrategyFactory identificationStrategyFactory) {
            this.identificationStrategyFactory = identificationStrategyFactory;
            return this;
        }

        public Builder feedbackCheckingStrategyFactory(FeedbackCheckingStrategyFactory feedbackCheckingStrategyFactory) {
            this.feedbackCheckingStrategyFactory = feedbackCheckingStrategyFactory;
            return this;
        }

        public Builder classificationStrategyFactory(ClassificationStrategyFactory classificationStrategyFactory) {
            this.classificationStrategyFactory = classificationStrategyFactory;
            return this;
        }

        public Builder constraintCheckingFactory(ConstraintCheckerFactory constraintCheckerFactory) {
            this.constraintCheckerFactory = constraintCheckerFactory;
            return this;
        }

        public Builder executionReporter(InterleavingExecutionReporter executionReporter) {
            this.executionReporters.add((InterleavingExecutionReporter)Preconditions.notNull((Object)executionReporter));
            return this;
        }

        public Builder executionReporters(InterleavingExecutionReporter ... executionReporters) {
            Preconditions.notNull((Object)executionReporters);
            for (InterleavingExecutionReporter executionReporter : executionReporters) {
                this.executionReporters.add((InterleavingExecutionReporter)Preconditions.notNull((Object)executionReporter));
            }
            return this;
        }

        public Builder executionReporters(Collection<InterleavingExecutionReporter> executionReporters) {
            Preconditions.notNull(executionReporters);
            Preconditions.check((!executionReporters.contains(null) ? 1 : 0) != 0);
            this.executionReporters.addAll(executionReporters);
            return this;
        }

        public Builder argumentConverter(ArgumentConverter argumentConverter) {
            this.argumentConverters.add((ArgumentConverter)Preconditions.notNull((Object)argumentConverter));
            return this;
        }

        public Builder argumentConverters(ArgumentConverter ... argumentConverters) {
            Preconditions.notNull((Object)argumentConverters);
            for (ArgumentConverter argumentConverter : argumentConverters) {
                this.argumentConverters.add((ArgumentConverter)Preconditions.notNull((Object)argumentConverter));
            }
            return this;
        }

        public Builder argumentConverters(Collection<ArgumentConverter> argumentConverters) {
            Preconditions.notNull(argumentConverters);
            Preconditions.check((!argumentConverters.contains(null) ? 1 : 0) != 0);
            this.argumentConverters.addAll(argumentConverters);
            return this;
        }

        public Builder executionMode(ExecutionMode executionMode) {
            this.executionMode = (ExecutionMode)Preconditions.notNull((Object)executionMode);
            return this;
        }

        public Builder isGenerating(boolean isGenerating) {
            this.isGenerating = (Boolean)Preconditions.notNull((Object)isGenerating);
            return this;
        }

        @Override
        public InterleavingExecutionConfiguration build() {
            return new InterleavingExecutionConfiguration(this);
        }
    }
}

