/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.execution;

import de.rwth.swc.coffee4j.algorithmic.classification.ClassificationStrategyFactory;
import de.rwth.swc.coffee4j.algorithmic.classification.NoOpClassificationStrategy;
import de.rwth.swc.coffee4j.algorithmic.configuration.execution.ExecutionMode;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictDetectionConfiguration;
import de.rwth.swc.coffee4j.algorithmic.report.ArgumentConverter;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.generator.TestInputGroupGenerator;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.BasicSequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.CachingDelegatingSequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.ConstraintGeneratingSequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.HashMapTestResultCache;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.TestResultCache;
import de.rwth.swc.coffee4j.algorithmic.sequential.prioritization.NoOpTestInputPrioritizer;
import de.rwth.swc.coffee4j.algorithmic.sequential.prioritization.TestInputPrioritizer;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.Buildable;
import de.rwth.swc.coffee4j.engine.converter.model.IndexBasedModelConverter;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverterFactory;
import de.rwth.swc.coffee4j.engine.process.manager.sequential.CombinatorialTestManagerFactory;
import de.rwth.swc.coffee4j.engine.report.SequentialExecutionReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SequentialExecutionConfiguration {
    private final CombinatorialTestManagerFactory managerFactory;
    private final ModelConverterFactory modelConverterFactory;
    private final ConflictDetectionConfiguration conflictDetectionConfiguration;
    private final FaultCharacterizationAlgorithmFactory characterizationAlgorithmFactory;
    private final ClassificationStrategyFactory classificationStrategyFactory;
    private final List<TestInputGroupGenerator> generators;
    private final TestInputPrioritizer prioritizer;
    private final List<SequentialExecutionReporter> executionReporters;
    private final List<ArgumentConverter> argumentConverters;
    private final ExecutionMode executionMode;
    private final boolean isConstraintGenerator;

    private SequentialExecutionConfiguration(Builder builder) {
        this.managerFactory = builder.managerFactory;
        this.modelConverterFactory = (ModelConverterFactory)Preconditions.notNull((Object)builder.modelConverterFactory);
        this.conflictDetectionConfiguration = (ConflictDetectionConfiguration)Preconditions.notNull((Object)builder.conflictDetectionConfiguration);
        this.characterizationAlgorithmFactory = builder.characterizationAlgorithmFactory;
        this.classificationStrategyFactory = builder.classificationStrategyFactory;
        this.generators = builder.generators;
        this.prioritizer = builder.prioritizer;
        this.executionReporters = builder.executionReporters;
        this.argumentConverters = builder.argumentConverters;
        this.executionMode = (ExecutionMode)Preconditions.notNull((Object)builder.executionMode);
        this.isConstraintGenerator = builder.isConstraintGenerator;
    }

    public CombinatorialTestManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public ModelConverterFactory getModelConverterFactory() {
        return this.modelConverterFactory;
    }

    public ConflictDetectionConfiguration getConflictDetectionConfiguration() {
        return this.conflictDetectionConfiguration;
    }

    public Optional<FaultCharacterizationAlgorithmFactory> getCharacterizationAlgorithmFactory() {
        return Optional.ofNullable(this.characterizationAlgorithmFactory);
    }

    public ClassificationStrategyFactory getClassificationStrategyFactory() {
        return this.classificationStrategyFactory;
    }

    public List<TestInputGroupGenerator> getGenerators() {
        return this.generators;
    }

    public TestInputPrioritizer getPrioritizer() {
        return this.prioritizer;
    }

    public List<SequentialExecutionReporter> getExecutionReporters() {
        return this.executionReporters;
    }

    public List<ArgumentConverter> getArgumentConverters() {
        return this.argumentConverters;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public boolean isConstraintGenerator() {
        return this.isConstraintGenerator;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SequentialExecutionConfiguration other = (SequentialExecutionConfiguration)object;
        return Objects.equals(this.managerFactory, other.managerFactory) && Objects.equals(this.modelConverterFactory, other.modelConverterFactory) && Objects.equals(this.conflictDetectionConfiguration, other.conflictDetectionConfiguration) && Objects.equals(this.characterizationAlgorithmFactory, other.characterizationAlgorithmFactory) && Objects.equals(this.classificationStrategyFactory, other.classificationStrategyFactory) && Objects.equals(this.generators, other.generators) && Objects.equals(this.executionReporters, other.executionReporters) && Objects.equals(this.argumentConverters, other.argumentConverters) && Objects.equals(this.executionMode, other.executionMode) && Objects.equals(this.isConstraintGenerator, other.isConstraintGenerator);
    }

    public int hashCode() {
        return Objects.hash(this.managerFactory, this.modelConverterFactory, this.conflictDetectionConfiguration, this.characterizationAlgorithmFactory, this.classificationStrategyFactory, this.generators, this.executionReporters, this.argumentConverters, this.executionMode, this.isConstraintGenerator);
    }

    public String toString() {
        return "CombinatorialTestExecutionConfiguration{managerFactory=" + this.managerFactory + ", modelConverterFactory=" + this.modelConverterFactory + ", conflictDetectionConfiguration=" + this.conflictDetectionConfiguration + ", characterizationAlgorithmFactory=" + this.characterizationAlgorithmFactory + ", classificationStrategyFactory=" + this.classificationStrategyFactory + ", generators=" + this.generators + ", executionReporters=" + this.executionReporters + ", argumentConverters=" + this.argumentConverters + ", executionMode=" + this.executionMode + ", isConstraintGenerator=" + this.isConstraintGenerator + "}";
    }

    public static Builder executionConfiguration() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SequentialExecutionConfiguration.executionConfiguration().managerFactory(this.managerFactory).modelConverterFactory(this.modelConverterFactory).faultCharacterizationAlgorithmFactory(this.characterizationAlgorithmFactory).classificationStrategyFactory(this.classificationStrategyFactory).conflictDetectionConfiguration(this.conflictDetectionConfiguration).generators(this.generators).prioritizer(this.prioritizer).executionReporters(this.executionReporters).argumentConverters(this.argumentConverters).executionMode(this.executionMode).isConstraintGenerator(this.isConstraintGenerator);
    }

    public static final class Builder
    implements Buildable<SequentialExecutionConfiguration> {
        private CombinatorialTestManagerFactory managerFactory = (configuration, generationReporter) -> new CachingDelegatingSequentialCombinatorialTestManager((TestResultCache)new HashMapTestResultCache(), (SequentialCombinatorialTestManager)new BasicSequentialCombinatorialTestManager(configuration, generationReporter));
        private ModelConverterFactory modelConverterFactory = IndexBasedModelConverter::new;
        private FaultCharacterizationAlgorithmFactory characterizationAlgorithmFactory;
        private ClassificationStrategyFactory classificationStrategyFactory;
        private ConflictDetectionConfiguration conflictDetectionConfiguration = ConflictDetectionConfiguration.disable();
        private final List<TestInputGroupGenerator> generators = new ArrayList<TestInputGroupGenerator>();
        private TestInputPrioritizer prioritizer = new NoOpTestInputPrioritizer();
        private final List<SequentialExecutionReporter> executionReporters = new ArrayList<SequentialExecutionReporter>();
        private final List<ArgumentConverter> argumentConverters = new ArrayList<ArgumentConverter>();
        private ExecutionMode executionMode = ExecutionMode.EXECUTE_ALL;
        private boolean isConstraintGenerator = false;

        public Builder managerFactory(CombinatorialTestManagerFactory managerFactory) {
            this.managerFactory = managerFactory;
            return this;
        }

        public Builder modelConverterFactory(ModelConverterFactory modelConverterFactory) {
            this.modelConverterFactory = modelConverterFactory;
            return this;
        }

        public Builder faultCharacterizationAlgorithmFactory(FaultCharacterizationAlgorithmFactory characterizationAlgorithmFactory) {
            this.characterizationAlgorithmFactory = characterizationAlgorithmFactory;
            return this;
        }

        public Builder classificationStrategyFactory(ClassificationStrategyFactory classificationStrategyFactory) {
            this.classificationStrategyFactory = classificationStrategyFactory;
            return this;
        }

        public Builder conflictDetectionConfiguration(ConflictDetectionConfiguration constraintDiagnosisEnabled) {
            this.conflictDetectionConfiguration = constraintDiagnosisEnabled;
            return this;
        }

        public Builder executionReporter(SequentialExecutionReporter executionReporter) {
            this.executionReporters.add((SequentialExecutionReporter)Preconditions.notNull((Object)executionReporter));
            return this;
        }

        public Builder executionReporters(SequentialExecutionReporter ... executionReporters) {
            Preconditions.notNull((Object)executionReporters);
            for (SequentialExecutionReporter executionReporter : executionReporters) {
                this.executionReporters.add((SequentialExecutionReporter)Preconditions.notNull((Object)executionReporter));
            }
            return this;
        }

        public Builder executionReporters(Collection<? extends SequentialExecutionReporter> executionReporters) {
            Preconditions.notNull(executionReporters);
            this.executionReporters.addAll(executionReporters);
            return this;
        }

        public Builder argumentConverter(ArgumentConverter argumentConverter) {
            this.argumentConverters.add((ArgumentConverter)Preconditions.notNull((Object)argumentConverter));
            return this;
        }

        public Builder argumentConverters(ArgumentConverter ... argumentConverters) {
            Preconditions.notNull((Object)argumentConverters);
            for (ArgumentConverter argumentConverter : argumentConverters) {
                this.argumentConverters.add((ArgumentConverter)Preconditions.notNull((Object)argumentConverter));
            }
            return this;
        }

        public Builder argumentConverters(Collection<ArgumentConverter> argumentConverters) {
            Preconditions.notNull(argumentConverters);
            this.argumentConverters.addAll(argumentConverters);
            return this;
        }

        public Builder generator(TestInputGroupGenerator generator) {
            this.generators.add((TestInputGroupGenerator)Preconditions.notNull((Object)generator));
            return this;
        }

        public Builder generators(TestInputGroupGenerator ... generators) {
            Preconditions.notNull((Object)generators);
            for (TestInputGroupGenerator generator : generators) {
                this.generators.add((TestInputGroupGenerator)Preconditions.notNull((Object)generator));
            }
            return this;
        }

        public Builder prioritizer(TestInputPrioritizer prioritizer) {
            Preconditions.notNull((Object)prioritizer);
            this.prioritizer = prioritizer;
            return this;
        }

        public Builder generators(Collection<TestInputGroupGenerator> generators) {
            Preconditions.notNull(generators);
            this.generators.addAll(generators);
            return this;
        }

        public Builder executionMode(ExecutionMode executionMode) {
            this.executionMode = (ExecutionMode)Preconditions.notNull((Object)executionMode);
            return this;
        }

        public Builder isConstraintGenerator(boolean flag) {
            this.isConstraintGenerator = flag;
            if (flag) {
                if (this.classificationStrategyFactory == null) {
                    this.classificationStrategyFactory = NoOpClassificationStrategy.noOpClassificationStrategy();
                }
                this.managerFactory = (configuration, generationReporter) -> new CachingDelegatingSequentialCombinatorialTestManager((TestResultCache)new HashMapTestResultCache(), (SequentialCombinatorialTestManager)new ConstraintGeneratingSequentialCombinatorialTestManager(configuration, generationReporter));
            }
            return this;
        }

        @Override
        public SequentialExecutionConfiguration build() {
            return new SequentialExecutionConfiguration(this);
        }
    }
}

