/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.Buildable;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import de.rwth.swc.coffee4j.engine.configuration.model.Seed;
import de.rwth.swc.coffee4j.engine.configuration.model.StrengthGroup;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class InputParameterModel {
    private final int positiveTestingStrength;
    private final int negativeTestingStrength;
    private final String name;
    private final List<Parameter> parameters;
    private final List<Constraint> exclusionConstraints;
    private final List<Constraint> errorConstraints;
    private final List<Seed> positiveSeeds;
    private final Map<String, List<Seed>> negativeSeeds;
    private final List<StrengthGroup> positiveMixedStrengthGroups;

    private InputParameterModel(Builder builder) {
        Preconditions.notNull((Object)builder, (String)"builder must not be null");
        Preconditions.notNull((Object)builder.name);
        Preconditions.notNull(builder.parameters);
        Preconditions.notNull(builder.exclusionConstraints);
        Preconditions.notNull(builder.errorConstraints);
        Preconditions.notNull(builder.positiveSeeds);
        Preconditions.notNull(builder.negativeSeeds);
        Preconditions.notNull(builder.positiveMixedStrengthGroups);
        Preconditions.check((builder.positiveTestingStrength >= 0 ? 1 : 0) != 0);
        Preconditions.check((builder.positiveTestingStrength <= builder.parameters.size() ? 1 : 0) != 0);
        Preconditions.check((builder.negativeTestingStrength >= 0 ? 1 : 0) != 0);
        Preconditions.check((builder.negativeTestingStrength <= builder.parameters.size() ? 1 : 0) != 0);
        Preconditions.check((!builder.parameters.contains(null) ? 1 : 0) != 0);
        Preconditions.check((!builder.exclusionConstraints.contains(null) ? 1 : 0) != 0);
        Preconditions.check((!builder.errorConstraints.contains(null) ? 1 : 0) != 0);
        InputParameterModel.checkParameterDoesNotContainDuplicateName(builder.parameters);
        InputParameterModel.checkConstraintsOnlyReferenceValidParameters(builder.parameters, builder.exclusionConstraints, builder.errorConstraints);
        InputParameterModel.checkSeedsForCorrectParameters(builder.positiveSeeds, builder.parameters);
        this.checkNegativeSeedsForCorrectParametersAndConstraintNames(builder.negativeSeeds, builder.errorConstraints, builder.parameters);
        InputParameterModel.checkMixedStrengthGroupsForCorrectParameters(builder.positiveMixedStrengthGroups, builder.parameters);
        InputParameterModel.countAnonymousConstraints(builder.exclusionConstraints, builder.errorConstraints);
        this.positiveTestingStrength = builder.positiveTestingStrength;
        this.negativeTestingStrength = builder.negativeTestingStrength;
        this.name = builder.name;
        this.parameters = new ArrayList<Parameter>(builder.parameters);
        this.exclusionConstraints = new ArrayList<Constraint>(builder.exclusionConstraints);
        this.errorConstraints = new ArrayList<Constraint>(builder.errorConstraints);
        this.positiveSeeds = new ArrayList<Seed>(builder.positiveSeeds);
        this.negativeSeeds = new HashMap<String, List<Seed>>(builder.negativeSeeds);
        this.positiveMixedStrengthGroups = new ArrayList<StrengthGroup>(builder.positiveMixedStrengthGroups);
    }

    private static void countAnonymousConstraints(Collection<Constraint> exclusionConstraints, Collection<Constraint> errorConstraints) {
        int count = 0;
        for (Constraint constraint : exclusionConstraints) {
            if (!constraint.getName().equals("")) continue;
            constraint.setName("unknown-" + ++count);
        }
        for (Constraint constraint : errorConstraints) {
            if (!constraint.getName().equals("")) continue;
            constraint.setName("unknown-" + ++count);
        }
    }

    private static void checkParameterDoesNotContainDuplicateName(List<Parameter> parameters) {
        HashSet<String> parameterNames = new HashSet<String>();
        for (Parameter parameter : parameters) {
            String parameterName = parameter.getName();
            if (parameterNames.contains(parameterName)) {
                throw new IllegalArgumentException("Parameter name " + parameterName + " appears twice");
            }
            parameterNames.add(parameterName);
        }
    }

    private static void checkConstraintsOnlyReferenceValidParameters(List<Parameter> parameters, Collection<Constraint> exclusionConstraints, Collection<Constraint> errorConstraints) {
        Set parameterNames = parameters.stream().map(Parameter::getName).collect(Collectors.toSet());
        for (Constraint constraint : exclusionConstraints) {
            for (String parameterName : constraint.getParameterNames()) {
                if (parameterNames.contains(parameterName)) continue;
                throw new IllegalArgumentException("Exclusion constraint \"" + constraint.getName() + "\"references unknown parameter \"" + parameterName + "\".");
            }
        }
        for (Constraint constraint : errorConstraints) {
            for (String parameterName : constraint.getParameterNames()) {
                if (parameterNames.contains(parameterName)) continue;
                throw new IllegalArgumentException("Error constraint \"" + constraint.getName() + "\"references unknown parameter \"" + parameterName + "\".");
            }
        }
    }

    private static void checkSeedsForCorrectParameters(List<Seed> seeds, List<Parameter> parameters) {
        for (Seed seed : seeds) {
            Set<Parameter> seedParameters = seed.getCombination().getParameterValueMap().keySet();
            Preconditions.check((boolean)parameters.containsAll(seedParameters), (String)"All parameters used in seed test cases need to be present in the model");
        }
    }

    private void checkNegativeSeedsForCorrectParametersAndConstraintNames(Map<String, List<Seed>> negativeSeeds, List<Constraint> errorConstraints, List<Parameter> parameters) {
        for (Map.Entry<String, List<Seed>> errorConstraintSeeds : negativeSeeds.entrySet()) {
            String constraintName = errorConstraintSeeds.getKey();
            Preconditions.check((boolean)errorConstraints.stream().anyMatch(constraint -> constraint.getName().equals(constraintName)), (String)("No matching error constraint for seed group " + constraintName));
            InputParameterModel.checkSeedsForCorrectParameters(errorConstraintSeeds.getValue(), parameters);
        }
    }

    private static void checkMixedStrengthGroupsForCorrectParameters(Collection<StrengthGroup> strengthGroups, Collection<Parameter> parameters) {
        for (StrengthGroup strengthGroup : strengthGroups) {
            for (Parameter parameter : strengthGroup.getParameters()) {
                Preconditions.check((boolean)parameters.contains(parameter), (String)("Parameter " + parameter + " is contained in strength group " + strengthGroup + " but not in model parameters " + parameter));
            }
        }
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int getPositiveTestingStrength() {
        return this.positiveTestingStrength;
    }

    public int getNegativeTestingStrength() {
        return this.negativeTestingStrength;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Constraint> getExclusionConstraints() {
        return this.exclusionConstraints;
    }

    public List<Constraint> getErrorConstraints() {
        return this.errorConstraints;
    }

    public List<Seed> getPositiveSeeds() {
        return this.positiveSeeds;
    }

    public Map<String, List<Seed>> getNegativeSeeds() {
        return this.negativeSeeds;
    }

    public List<StrengthGroup> getPositiveMixedStrengthGroups() {
        return this.positiveMixedStrengthGroups;
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputParameterModel model = (InputParameterModel)o;
        return this.positiveTestingStrength == model.positiveTestingStrength && this.negativeTestingStrength == model.negativeTestingStrength && Objects.equals(this.name, model.name) && Objects.equals(this.parameters, model.parameters) && Objects.equals(this.exclusionConstraints, model.exclusionConstraints) && Objects.equals(this.errorConstraints, model.errorConstraints) && Objects.equals(this.positiveSeeds, model.positiveSeeds) && Objects.equals(this.negativeSeeds, model.negativeSeeds) && Objects.equals(this.positiveMixedStrengthGroups, model.positiveMixedStrengthGroups);
    }

    public int hashCode() {
        return Objects.hash(this.positiveTestingStrength, this.negativeTestingStrength, this.name, this.parameters, this.exclusionConstraints, this.errorConstraints, this.positiveSeeds, this.negativeSeeds, this.positiveMixedStrengthGroups);
    }

    public String toString() {
        return "InputParameterModel{positive testing strength=" + this.positiveTestingStrength + ", negative testing strength=" + this.negativeTestingStrength + ", name='" + this.name + "', parameters=" + this.parameters + ", exclusionConstraints=" + this.exclusionConstraints + ", errorConstraints=" + this.errorConstraints + ", positiveSeeds=" + this.positiveSeeds + ", negativeSeeds=" + this.negativeSeeds + ", positiveMixedStrengthGroups=" + this.positiveMixedStrengthGroups + "}";
    }

    public static Builder inputParameterModel(String name) {
        return new Builder(name);
    }

    public static final class Builder
    implements Buildable<InputParameterModel> {
        private int positiveTestingStrength = 1;
        private int negativeTestingStrength = 0;
        private String name;
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private final List<Constraint> exclusionConstraints = new ArrayList<Constraint>();
        private final List<Constraint> errorConstraints = new ArrayList<Constraint>();
        private final List<Seed> positiveSeeds = new ArrayList<Seed>();
        private final Map<String, List<Seed>> negativeSeeds = new HashMap<String, List<Seed>>();
        private final List<StrengthGroup> positiveMixedStrengthGroups = new ArrayList<StrengthGroup>();

        private Builder(String name) {
            this.name = name;
        }

        private Builder(InputParameterModel model) {
            this.positiveTestingStrength = model.positiveTestingStrength;
            this.negativeTestingStrength = model.negativeTestingStrength;
            this.name = model.name;
            this.parameters.addAll(model.parameters);
            this.exclusionConstraints.addAll(model.exclusionConstraints);
            this.errorConstraints.addAll(model.errorConstraints);
            this.positiveSeeds.addAll(model.positiveSeeds);
            this.negativeSeeds.putAll(model.negativeSeeds);
        }

        public Builder positiveTestingStrength(int strength) {
            this.positiveTestingStrength = strength;
            return this;
        }

        public Builder negativeTestingStrength(int strength) {
            this.negativeTestingStrength = strength;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder parameter(Parameter parameter) {
            Preconditions.notNull((Object)parameter);
            this.parameters.add(parameter);
            return this;
        }

        public Builder parameter(Parameter.Builder parameter) {
            Preconditions.notNull((Object)parameter);
            this.parameters.add(parameter.build());
            return this;
        }

        public Builder parameters(Parameter ... parameters) {
            Preconditions.notNull((Object)parameters);
            this.parameters.clear();
            for (Parameter parameter : parameters) {
                this.parameter(parameter);
            }
            return this;
        }

        public Builder parameters(Collection<Parameter> parameters) {
            Preconditions.notNull(parameters);
            this.parameters.clear();
            for (Parameter parameter : parameters) {
                this.parameter(parameter);
            }
            return this;
        }

        public Builder parameters(Parameter.Builder ... parameters) {
            Preconditions.notNull((Object)parameters);
            this.parameters.clear();
            for (Parameter.Builder parameter : parameters) {
                this.parameter(parameter);
            }
            return this;
        }

        public Builder exclusionConstraint(Constraint exclusionConstraint) {
            Preconditions.notNull((Object)exclusionConstraint);
            this.exclusionConstraints.add(exclusionConstraint);
            return this;
        }

        public Builder exclusionConstraints(Constraint ... exclusionConstraints) {
            Preconditions.notNull((Object)exclusionConstraints);
            for (Constraint constraint : exclusionConstraints) {
                this.exclusionConstraint(constraint);
            }
            return this;
        }

        public Builder removeExclusionConstraints() {
            this.exclusionConstraints.clear();
            return this;
        }

        public Builder errorConstraint(Constraint errorConstraint) {
            Preconditions.notNull((Object)errorConstraint);
            this.errorConstraints.add(errorConstraint);
            return this;
        }

        public Builder errorConstraints(Constraint ... errorConstraints) {
            Preconditions.notNull((Object)errorConstraints);
            for (Constraint constraint : errorConstraints) {
                this.errorConstraint(constraint);
            }
            return this;
        }

        public Builder errorConstraints(Collection<Constraint> errorConstraints) {
            Preconditions.notNull(errorConstraints);
            for (Constraint constraint : errorConstraints) {
                this.errorConstraint(constraint);
            }
            return this;
        }

        public Builder seed(Seed.Builder seed) {
            Preconditions.notNull((Object)seed);
            this.positiveSeeds.add(seed.build(this.parameters));
            return this;
        }

        public Builder seed(String errorConstraintName, Seed.Builder seed) {
            Preconditions.notNull((Object)seed);
            this.negativeSeeds.computeIfAbsent(errorConstraintName, key -> new ArrayList()).add(seed.build(this.parameters));
            return this;
        }

        public Builder seeds(Seed.Builder ... seeds) {
            Preconditions.notNull((Object)seeds);
            for (Seed.Builder seed : seeds) {
                this.seed(seed);
            }
            return this;
        }

        public Builder seeds(String errorConstraintName, Seed.Builder ... seeds) {
            Preconditions.notNull((Object)seeds);
            List errorConstraintSeeds = this.negativeSeeds.computeIfAbsent(errorConstraintName, key -> new ArrayList());
            for (Seed.Builder seed : seeds) {
                errorConstraintSeeds.add(seed.build(this.parameters));
            }
            return this;
        }

        public Builder mixedStrengthGroup(StrengthGroup.Builder mixedStrengthGroup) {
            this.positiveMixedStrengthGroups.add(mixedStrengthGroup.build(this.parameters));
            return this;
        }

        public Builder mixedStrengthGroups(StrengthGroup.Builder ... mixedStrengthGroups) {
            for (StrengthGroup.Builder mixedStrengthGroup : mixedStrengthGroups) {
                this.positiveMixedStrengthGroups.add(mixedStrengthGroup.build(this.parameters));
            }
            return this;
        }

        @Override
        public InputParameterModel build() {
            return new InputParameterModel(this);
        }
    }
}

