/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Value;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Parameter {
    private final String name;
    private final List<Value> values;

    public Parameter(String name, Collection<Value> values) {
        Preconditions.notNull((Object)name);
        Preconditions.notNull(values);
        Preconditions.check((values.size() >= 2 ? 1 : 0) != 0);
        Preconditions.doesNotContainNull(values);
        Preconditions.check((boolean)Parameter.doesNotContainSameValueIdTwice(values));
        this.name = name;
        this.values = new ArrayList<Value>(values);
    }

    private static boolean doesNotContainSameValueIdTwice(Collection<Value> values) {
        IntOpenHashSet valueIds = new IntOpenHashSet(values.size());
        for (Value value : values) {
            if (valueIds.contains(value.getId())) {
                return false;
            }
            valueIds.add(value.getId());
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public List<Value> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public int size() {
        return this.values.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Parameter other = (Parameter)object;
        return Objects.equals(this.name, other.name) && Objects.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String toString() {
        return "Parameter{name='" + this.name + "', values=" + this.values + "}";
    }

    public static Builder parameter(String name) {
        return new Builder(name);
    }

    public static Builder booleanParameter(String name) {
        return new Builder(name).values(true, false);
    }

    public static Builder enumParameter(String name, Class<? extends Enum<?>> enumClass) {
        Object[] values = enumClass.getEnumConstants();
        return new Builder(name).values(values);
    }

    public static final class Builder {
        private final String name;
        private final List<Value> values = new ArrayList<Value>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder value(Object value) {
            int nextId = this.values.size();
            if (value instanceof Value.Builder) {
                Value.Builder valueBuilder = (Value.Builder)value;
                this.values.add(valueBuilder.build(nextId));
            } else {
                this.values.add(new Value(nextId, value));
            }
            return this;
        }

        public Builder values(Object ... values) {
            Preconditions.notNull((Object)values);
            for (Object value : values) {
                this.value(value);
            }
            return this;
        }

        public Parameter build() {
            return new Parameter(this.name, this.values);
        }
    }
}

