/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model;

import de.rwth.swc.coffee4j.algorithmic.Coffee4JException;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class StrengthGroup {
    private final Set<Parameter> parameters;
    private final int strength;

    private StrengthGroup(Collection<Parameter> parameters, int strength) {
        Preconditions.notNull(parameters, (String)"parameters required");
        Preconditions.check((strength >= 0 && strength <= parameters.size() ? 1 : 0) != 0, (String)("Strength for parameters " + parameters + " must be int range [0," + parameters.size() + "] but was " + strength));
        this.parameters = new HashSet<Parameter>(parameters);
        this.strength = strength;
    }

    public static Builder mixedStrengthGroup(String ... parameterNames) {
        return StrengthGroup.mixedStrengthGroup(List.of(parameterNames));
    }

    public static Builder mixedStrengthGroup(Collection<String> parameterNames) {
        return new Builder(parameterNames);
    }

    public Set<Parameter> getParameters() {
        return this.parameters;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StrengthGroup other = (StrengthGroup)object;
        return this.strength == other.strength && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.strength);
    }

    public String toString() {
        return "ParameterStrengthGroup{parameters=" + this.parameters + ", strength=" + this.strength + "}";
    }

    public static final class Builder {
        private final List<String> parameterNames;
        private int strength;

        private Builder(Collection<String> parameterNames) {
            Preconditions.notNull(parameterNames);
            Preconditions.check((!parameterNames.isEmpty() ? 1 : 0) != 0, (String)"A mixed strength group must contain at least one parameter");
            this.parameterNames = new ArrayList<String>(parameterNames);
            this.strength = parameterNames.size();
        }

        public Builder ofHighestStrength() {
            this.strength = this.parameterNames.size();
            return this;
        }

        public Builder ofStrength(int strength) {
            this.strength = strength;
            return this;
        }

        public StrengthGroup build(Collection<Parameter> parameters) {
            Set<Parameter> groupParameters = this.parameterNames.stream().map(parameterName -> parameters.stream().filter(parameter -> parameter.getName().equals(parameterName)).findFirst().orElseThrow(() -> new Coffee4JException("Could not find parameter with name " + parameterName))).collect(Collectors.toSet());
            return new StrengthGroup(groupParameters, this.strength);
        }
    }
}

