/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model;

import java.util.Objects;
import java.util.OptionalDouble;

public final class Value {
    private final int id;
    private final Object data;
    private final Double weight;

    public Value(int id, Object data) {
        this(id, data, null);
    }

    public Value(int id, Object data, Double weight) {
        this.id = id;
        this.data = data;
        this.weight = weight;
    }

    public int getId() {
        return this.id;
    }

    public Object get() {
        return this.data;
    }

    public OptionalDouble getWeight() {
        if (this.weight == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.weight);
    }

    public double getRequiredWeight() {
        if (this.weight == null) {
            throw new IllegalStateException("weight was required but is not present");
        }
        return this.weight;
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Value other = (Value)object;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return (this.data == null ? "null" : this.data.toString()) + (String)(this.weight == null ? "" : " (weight=" + this.weight + ")");
    }

    public static Value value(int id, Object data) {
        return new Value(id, data);
    }

    public static Value value(int id, Object data, double weight) {
        return new Value(id, data, weight);
    }

    public static Builder weighted(Object data, double weight) {
        return new Builder(data, weight);
    }

    public static final class Builder {
        private final Object data;
        private final double weight;

        private Builder(Object data, double weight) {
            this.data = data;
            this.weight = weight;
        }

        public Value build(int id) {
            return new Value(id, this.data, this.weight);
        }
    }
}

