/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.configuration.model.constraints;

import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.ConstraintStatus;
import java.util.Collections;
import java.util.List;

public abstract class AbstractConstraint
implements Constraint {
    private String name;
    private final List<String> parameterNames;
    private final ConstraintStatus constraintStatus;

    public AbstractConstraint(String name, List<String> parameterNames, ConstraintStatus constraintStatus) {
        Preconditions.notNull((Object)name);
        Preconditions.notNull(parameterNames);
        Preconditions.notNull((Object)((Object)constraintStatus));
        Preconditions.check((!parameterNames.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        this.parameterNames = parameterNames;
        this.constraintStatus = constraintStatus;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.parameterNames);
    }

    @Override
    public ConstraintStatus getConstraintStatus() {
        return this.constraintStatus;
    }

    public String toString() {
        return "Constraint {name=" + this.name + ", parameterNames=(" + String.join((CharSequence)", ", this.parameterNames) + ")}";
    }
}

