/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.converter.constraints.methodbased;

import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Combinator;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.Parameter;
import de.rwth.swc.coffee4j.engine.configuration.model.Value;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.ConstraintStatus;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.methodbased.MethodBasedConstraint;
import de.rwth.swc.coffee4j.engine.converter.constraints.AbstractIndexBasedConstraintConverter;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SimpleCartesianProductConstraintConverter
extends AbstractIndexBasedConstraintConverter {
    public SimpleCartesianProductConstraintConverter(List<Parameter> parameters) {
        super(parameters);
    }

    @Override
    protected TupleList convertedConstraint(Constraint constraint, Object2IntMap<String> parameterIdMap, Int2ObjectMap<Parameter> idToParameterMap, int id) {
        Preconditions.check((boolean)(constraint instanceof MethodBasedConstraint));
        int[] relevantParameters = constraint.getParameterNames().stream().mapToInt(arg_0 -> parameterIdMap.getInt(arg_0)).toArray();
        Int2IntMap relevantParameterSizes = this.computeSizeMap(idToParameterMap, relevantParameters);
        List cartesianProduct = Combinator.computeCartesianProduct((Int2IntMap)relevantParameterSizes, (int)relevantParameters.length);
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        for (int[] combination : cartesianProduct) {
            Combination convertedCombination = this.mapToCombination(combination, relevantParameters, idToParameterMap);
            if (constraint.checkIfValid(convertedCombination)) continue;
            int[] tuple = new int[combination.length];
            System.arraycopy(combination, 0, tuple, 0, combination.length);
            tuples.add(tuple);
        }
        if (tuples.isEmpty()) {
            throw new IllegalArgumentException("Constraint \"" + constraint.getName() + "\" on parameters \"" + constraint.getParameterNames() + "\" allows all values. This is most likely an error in the constraint function.");
        }
        if (tuples.size() == cartesianProduct.size()) {
            throw new IllegalArgumentException("Constraint \"" + constraint.getName() + "\" on parameters \"" + constraint.getParameterNames() + "\" does not permit any values. This is most likely an error in the constraint function.");
        }
        return new TupleList(id, relevantParameters, tuples, constraint.getConstraintStatus().equals((Object)ConstraintStatus.CORRECT));
    }

    private Int2IntMap computeSizeMap(Int2ObjectMap<Parameter> idToParameterMap, int[] relevantKeys) {
        Int2IntOpenHashMap subMap = new Int2IntOpenHashMap();
        for (int i = 0; i < relevantKeys.length; ++i) {
            Parameter relevantParameter = (Parameter)idToParameterMap.get(relevantKeys[i]);
            subMap.put(i, relevantParameter.size());
        }
        return subMap;
    }

    private Combination mapToCombination(int[] combination, int[] relevantParameters, Int2ObjectMap<Parameter> idToParameterMap) {
        HashMap<Parameter, Value> parameterValueMap = new HashMap<Parameter, Value>();
        for (int i = 0; i < relevantParameters.length; ++i) {
            int valueId = combination[i];
            Parameter parameter = (Parameter)idToParameterMap.get(relevantParameters[i]);
            Value value = parameter.getValues().get(valueId);
            parameterValueMap.put(parameter, value);
        }
        return Combination.of(parameterValueMap);
    }
}

