/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.manager.sequential;

import de.rwth.swc.coffee4j.algorithmic.configuration.execution.ExecutionMode;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.manager.ConflictDetector;
import de.rwth.swc.coffee4j.engine.process.manager.PhaseManager;
import de.rwth.swc.coffee4j.engine.process.manager.sequential.SequentialPhaseManagerConfiguration;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionContext;
import de.rwth.swc.coffee4j.engine.process.phase.execution.ExecutionPhase;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationContext;
import de.rwth.swc.coffee4j.engine.process.phase.model.ModelModificationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.characterization.FaultCharacterizationPhase;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.generation.SequentialGenerationContext;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.generation.SequentialGenerationPhase;
import de.rwth.swc.coffee4j.engine.report.DelegatingSequentialExecutionReporter;
import java.util.List;
import java.util.Map;

public abstract class AbstractSequentialPhaseManager
implements PhaseManager {
    protected SequentialPhaseManagerConfiguration configuration;
    protected ExecutionContext executionContext;
    protected SequentialGenerationContext generationContext;
    protected ExtensionExecutor extensionExecutor;
    protected ExecutionPhase executionPhase;
    protected SequentialGenerationPhase generationPhase;
    protected FaultCharacterizationPhase faultCharacterizationPhase;

    public AbstractSequentialPhaseManager(SequentialPhaseManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void run() {
        Map<Combination, TestResult> executionResults;
        this.executeModelModificationPhase();
        this.createTestContexts();
        this.detectConflicts();
        this.createTestPhases();
        List<Combination> currentCombinations = this.generationPhase.execute(this.configuration.getTestMethodConfiguration().getInputParameterModel());
        do {
            executionResults = this.executionPhase.execute(currentCombinations);
            this.executionPhase.setExecutionMode(ExecutionMode.EXECUTE_ALL);
            this.collectErrorConstraintExceptionCausingTestInputs(executionResults);
        } while (!(currentCombinations = this.faultCharacterizationPhase.execute(executionResults)).isEmpty());
        this.executeClassificationPhase();
    }

    private void executeModelModificationPhase() {
        this.extensionExecutor = this.configuration.getExtensionExecutorFactory().create(this.configuration.getExtensions());
        ModelModificationContext context = new ModelModificationContext(this.extensionExecutor, new DelegatingSequentialExecutionReporter(this.configuration.getExecutionConfiguration().getExecutionReporters()));
        ModelModificationPhase phase = this.configuration.getModelModificationPhaseFactory().create(context);
        InputParameterModel model = this.configuration.getTestMethodConfiguration().getInputParameterModel();
        InputParameterModel modifiedModel = phase.execute(model);
        this.configuration = this.configuration.toBuilder().testMethodConfiguration(this.configuration.getTestMethodConfiguration().toBuilder().inputParameterModel(modifiedModel).build()).build();
    }

    private void createTestContexts() {
        this.executionContext = ExecutionContext.createExecutionContext(this.extensionExecutor, this.configuration.getTestMethodConfiguration(), this.configuration.getExecutionConfiguration().getExecutionReporters());
        this.generationContext = new SequentialGenerationContext(this.configuration.getExecutionConfiguration(), this.configuration.getTestMethodConfiguration().getInputParameterModel(), this.extensionExecutor);
    }

    private void detectConflicts() {
        ConflictDetector conflictDetector = this.configuration.getConflictDetectorFactory().create(this.configuration.getExecutionConfiguration().getConflictDetectionConfiguration(), this.generationContext.getModelConverter());
        conflictDetector.diagnoseConstraints();
    }

    protected void createTestPhases() {
        this.executionPhase = this.configuration.getExecutionPhaseFactory().create(this.executionContext);
        this.executionPhase.setExecutionMode(this.configuration.getExecutionConfiguration().getExecutionMode());
        this.generationPhase = this.configuration.getGenerationPhaseFactory().create(this.generationContext);
        this.faultCharacterizationPhase = this.configuration.getFaultCharacterizationPhaseFactory().create(this.generationContext);
    }

    protected abstract void collectErrorConstraintExceptionCausingTestInputs(Map<Combination, TestResult> var1);

    protected abstract void executeClassificationPhase();
}

