/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.interleaving.classification;

import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.GeneratingInterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.phase.AbstractPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationContext;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.commons.function.Try;

public class InterleavingClassificationPhase
extends AbstractPhase<InterleavingGenerationContext, Map<Combination, TestResult>, Combination> {
    protected final GeneratingInterleavingCombinatorialTestManager testManager;
    protected final ModelConverter modelConverter;

    public InterleavingClassificationPhase(InterleavingGenerationContext context) {
        super(context);
        Preconditions.check((boolean)(context.getTestManager() instanceof GeneratingInterleavingCombinatorialTestManager));
        this.testManager = (GeneratingInterleavingCombinatorialTestManager)context.getTestManager();
        this.modelConverter = context.getModelConverter();
    }

    public Combination initialize(Map<Combination, TestResult> errorConstraintExceptionCausingTestInputs) {
        Optional optNextTestInput = this.testManager.initializeClassification(errorConstraintExceptionCausingTestInputs.entrySet().stream().map(testInput -> Map.entry(this.modelConverter.convertCombination((Combination)testInput.getKey()), (TestResult)testInput.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Combination nextTestInput = null;
        if (optNextTestInput.isPresent()) {
            nextTestInput = this.modelConverter.convertCombination((int[])optNextTestInput.get());
        }
        return nextTestInput;
    }

    @Override
    public Combination execute(Map<Combination, TestResult> input) {
        Preconditions.notNull(input);
        Preconditions.check((boolean)Try.call(() -> !input.containsKey(null)).toOptional().orElse(true));
        Preconditions.check((boolean)Try.call(() -> !input.containsValue(null)).toOptional().orElse(true));
        Optional optEntry = input.entrySet().stream().findFirst();
        Map.Entry previouslyExecutedTest = null;
        if (optEntry.isPresent()) {
            previouslyExecutedTest = (Map.Entry)optEntry.get();
        }
        assert (previouslyExecutedTest != null);
        Optional optNextTestInput = this.testManager.generateNextTestInput(this.modelConverter.convertCombination((Combination)previouslyExecutedTest.getKey()), (TestResult)previouslyExecutedTest.getValue());
        Combination nextTestInput = null;
        if (optNextTestInput.isPresent()) {
            nextTestInput = this.modelConverter.convertCombination((int[])optNextTestInput.get());
        }
        return nextTestInput;
    }
}

