/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation;

import de.rwth.swc.coffee4j.algorithmic.interleaving.InterleavingCombinatorialTestGroup;
import de.rwth.swc.coffee4j.algorithmic.interleaving.report.InterleavingGenerationReporter;
import de.rwth.swc.coffee4j.algorithmic.report.ArgumentConverter;
import de.rwth.swc.coffee4j.algorithmic.report.Report;
import de.rwth.swc.coffee4j.algorithmic.report.ReportLevel;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.report.InterleavingExecutionReporter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class InterleavingExecutionReporterToGenerationReporterAdapter
implements InterleavingGenerationReporter {
    private final InterleavingExecutionReporter reporter;
    private final ArgumentConverter argumentConverter;
    private final ModelConverter modelConverter;

    public InterleavingExecutionReporterToGenerationReporterAdapter(InterleavingExecutionReporter reporter, ArgumentConverter argumentConverter, ModelConverter converter) {
        this.reporter = (InterleavingExecutionReporter)Preconditions.notNull((Object)reporter);
        this.argumentConverter = (ArgumentConverter)Preconditions.notNull((Object)argumentConverter);
        this.modelConverter = (ModelConverter)Preconditions.notNull((Object)converter);
    }

    private Combination convertCombination(int[] combination) {
        return this.modelConverter.convertCombination(combination);
    }

    private Set<Combination> convertCombinations(Collection<int[]> combinations) {
        return combinations.stream().map(this.modelConverter::convertCombination).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public void report(ReportLevel level, Report report) {
        Preconditions.notNull((Object)level);
        if (level.isWorseThanOrEqualTo(this.reporter.getReportLevel())) {
            report.convertArguments(this.argumentConverter);
            this.reporter.report(level, report);
        }
    }

    public void report(ReportLevel level, Supplier<Report> reportSupplier) {
        Preconditions.notNull((Object)level);
        Preconditions.notNull(reportSupplier);
        if (level.isWorseThanOrEqualTo(this.reporter.getReportLevel())) {
            Report report = reportSupplier.get();
            report.convertArguments(this.argumentConverter);
            this.reporter.report(level, report);
        }
    }

    public void interleavingGroupGenerated(InterleavingCombinatorialTestGroup group) {
        this.reporter.interleavingGroupGenerated(group);
    }

    public void interleavingGroupFinished(InterleavingCombinatorialTestGroup group, Map<int[], Class<? extends Throwable>> exceptionInducingCombinations, Set<int[]> possibleFailureInducingCombinations) {
        this.reporter.interleavingGroupFinished(group, exceptionInducingCombinations.entrySet().stream().map(entry -> Map.entry(this.convertCombination((int[])entry.getKey()), (Class)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), possibleFailureInducingCombinations.stream().map(this.modelConverter::convertCombination).collect(Collectors.toSet()));
    }

    public void identificationStarted(InterleavingCombinatorialTestGroup group, int[] failingTestInput) {
        this.reporter.identificationStarted(group, this.convertCombination(failingTestInput));
    }

    public void identificationFinished(InterleavingCombinatorialTestGroup group, Set<int[]> exceptionInducingCombinations, Set<int[]> failureInducingCombinations) {
        this.reporter.identificationFinished(group, this.convertCombinations(exceptionInducingCombinations), this.convertCombinations(failureInducingCombinations));
    }

    public void identificationTestInputGenerated(InterleavingCombinatorialTestGroup group, int[] testInput) {
        this.reporter.identificationTestInputGenerated(group, this.convertCombination(testInput));
    }

    public void checkingStarted(InterleavingCombinatorialTestGroup group, int[] failureInducingCombination) {
        this.reporter.checkingStarted(group, this.convertCombination(failureInducingCombination));
    }

    public void checkingFinished(InterleavingCombinatorialTestGroup group, int[] failureInducingCombination, boolean isFailureInducing) {
        this.reporter.checkingFinished(group, this.convertCombination(failureInducingCombination), isFailureInducing);
    }
}

