/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation;

import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.phase.AbstractPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class InterleavingGenerationPhase
extends AbstractPhase<InterleavingGenerationContext, Map<Combination, TestResult>, Combination> {
    private final ExtensionExecutor extensionExecutor;
    private final InterleavingCombinatorialTestManager testManager;
    private final ModelConverter converter;

    public InterleavingGenerationPhase(InterleavingGenerationContext context) {
        super(context);
        this.extensionExecutor = context.getExtensionExecutor();
        this.testManager = context.getTestManager();
        this.converter = context.getModelConverter();
    }

    @Override
    public Combination execute(Map<Combination, TestResult> previouslyExecutedTests) {
        Optional optNextTestInput;
        for (Map.Entry<Combination, TestResult> test : previouslyExecutedTests.entrySet()) {
            if (!test.getValue().isSuccessful()) continue;
            this.testManager.updateCoverage(this.converter.convertCombination(test.getKey()));
        }
        this.extensionExecutor.executeBeforeGeneration();
        Combination nextTestInput = null;
        ArrayList<Combination> nextTestInputList = new ArrayList<Combination>();
        Optional optEntry = previouslyExecutedTests.entrySet().stream().findFirst();
        if (optEntry.isPresent()) {
            Map.Entry previouslyExecutedTest = (Map.Entry)optEntry.get();
            optNextTestInput = this.testManager.generateNextTestInput(this.converter.convertCombination((Combination)previouslyExecutedTest.getKey()), (TestResult)previouslyExecutedTest.getValue());
        } else {
            optNextTestInput = this.testManager.generateNextTestInput(null, null);
        }
        if (optNextTestInput.isPresent()) {
            nextTestInput = this.converter.convertCombination((int[])optNextTestInput.get());
            nextTestInputList.add(nextTestInput);
        }
        this.extensionExecutor.executeAfterGeneration(nextTestInputList);
        return nextTestInput;
    }
}

