/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.interleaving.identification;

import de.rwth.swc.coffee4j.algorithmic.interleaving.manager.InterleavingCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.phase.AbstractPhase;
import de.rwth.swc.coffee4j.engine.process.phase.interleaving.generation.InterleavingGenerationContext;
import java.util.Map;
import java.util.Optional;
import org.junit.platform.commons.function.Try;

public class IdentificationPhase
extends AbstractPhase<InterleavingGenerationContext, Map<Combination, TestResult>, Combination> {
    private final InterleavingCombinatorialTestManager testManager;
    private final ModelConverter converter;

    public IdentificationPhase(InterleavingGenerationContext context) {
        super(context);
        this.testManager = context.getTestManager();
        this.converter = context.getModelConverter();
    }

    public Combination initialize(Combination testInput, TestResult result) {
        Optional nextTestInputOptional = this.testManager.initializeIdentification(this.converter.convertCombination(testInput), result);
        return nextTestInputOptional.map(this.converter::convertCombination).orElse(null);
    }

    public Combination reinitialize() {
        Optional nextTestInputOptional = this.testManager.reinitializeIdentification();
        return nextTestInputOptional.map(this.converter::convertCombination).orElse(null);
    }

    @Override
    public Combination execute(Map<Combination, TestResult> previouslyExecutedTests) {
        Preconditions.notNull(previouslyExecutedTests);
        Preconditions.check((boolean)Try.call(() -> !previouslyExecutedTests.containsKey(null)).toOptional().orElse(true));
        Preconditions.check((boolean)Try.call(() -> !previouslyExecutedTests.containsValue(null)).toOptional().orElse(true));
        for (Map.Entry<Combination, TestResult> test : previouslyExecutedTests.entrySet()) {
            if (!test.getValue().isSuccessful()) continue;
            this.testManager.updateCoverage(this.converter.convertCombination(test.getKey()));
        }
        Optional optEntry = previouslyExecutedTests.entrySet().stream().findFirst();
        Map.Entry previouslyExecutedTest = null;
        if (optEntry.isPresent()) {
            previouslyExecutedTest = (Map.Entry)optEntry.get();
        }
        assert (previouslyExecutedTest != null);
        Optional optNextTestInput = this.testManager.generateNextTestInput(this.converter.convertCombination((Combination)previouslyExecutedTest.getKey()), (TestResult)previouslyExecutedTest.getValue());
        Combination nextTestInput = null;
        if (optNextTestInput.isPresent()) {
            nextTestInput = this.converter.convertCombination((int[])optNextTestInput.get());
        }
        return nextTestInput;
    }
}

