/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.phase.sequential.generation;

import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithmFactory;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestConfiguration;
import de.rwth.swc.coffee4j.algorithmic.sequential.manager.SequentialCombinatorialTestManager;
import de.rwth.swc.coffee4j.algorithmic.sequential.report.GenerationReporter;
import de.rwth.swc.coffee4j.engine.configuration.execution.SequentialExecutionConfiguration;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.process.extension.ExtensionExecutor;
import de.rwth.swc.coffee4j.engine.process.phase.PhaseContext;
import de.rwth.swc.coffee4j.engine.process.phase.sequential.generation.SequentialExecutionReporterToGenerationReporterAdapter;
import de.rwth.swc.coffee4j.engine.process.report.sequential.LoggingSequentialExecutionReporter;
import de.rwth.swc.coffee4j.engine.process.report.sequential.LoggingSequentialExecutionReporterForGeneration;
import de.rwth.swc.coffee4j.engine.report.DelegatingModelBasedArgumentConverter;
import de.rwth.swc.coffee4j.engine.report.DelegatingSequentialExecutionReporter;
import de.rwth.swc.coffee4j.engine.report.ModelBasedArgumentConverter;
import de.rwth.swc.coffee4j.engine.report.SequentialExecutionReporter;
import java.util.List;

public class SequentialGenerationContext
implements PhaseContext {
    private final ModelConverter modelConverter;
    private final SequentialCombinatorialTestManager generator;
    private final ExtensionExecutor extensionExecutor;
    private final boolean isGenerating;

    public SequentialGenerationContext(SequentialExecutionConfiguration configuration, InputParameterModel model, ExtensionExecutor extensionExecutor) {
        this.extensionExecutor = extensionExecutor;
        this.modelConverter = configuration.getModelConverterFactory().create(model);
        this.isGenerating = configuration.isConstraintGenerator();
        DelegatingModelBasedArgumentConverter argumentConverterManager = new DelegatingModelBasedArgumentConverter(configuration.getArgumentConverters());
        ((ModelBasedArgumentConverter)argumentConverterManager).initialize(this.modelConverter);
        SequentialExecutionReporterToGenerationReporterAdapter reporterManager = new SequentialExecutionReporterToGenerationReporterAdapter(this.buildDelegatingOrDefaultExecutionReporter(configuration.getExecutionReporters()), argumentConverterManager, this.modelConverter);
        SequentialCombinatorialTestConfiguration testConfiguration = new SequentialCombinatorialTestConfiguration((FaultCharacterizationAlgorithmFactory)configuration.getCharacterizationAlgorithmFactory().orElse(null), configuration.getClassificationStrategyFactory(), configuration.getGenerators(), configuration.getPrioritizer(), (GenerationReporter)reporterManager, configuration.getExecutionMode());
        this.generator = (SequentialCombinatorialTestManager)configuration.getManagerFactory().apply(testConfiguration, this.modelConverter.getConvertedModel());
    }

    private SequentialExecutionReporter buildDelegatingOrDefaultExecutionReporter(List<SequentialExecutionReporter> executionReporters) {
        if (executionReporters.isEmpty()) {
            if (this.isGenerating) {
                return new LoggingSequentialExecutionReporterForGeneration();
            }
            return new LoggingSequentialExecutionReporter();
        }
        return new DelegatingSequentialExecutionReporter(executionReporters);
    }

    public ModelConverter getModelConverter() {
        return this.modelConverter;
    }

    public SequentialCombinatorialTestManager getGenerator() {
        return this.generator;
    }

    public ExtensionExecutor getExtensionExecutor() {
        return this.extensionExecutor;
    }
}

