/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.report;

import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisHittingSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.MissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.UnknownConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.report.ConflictDetectionReporter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConflictDetectionReporter
implements ConflictDetectionReporter {
    private final Logger logger = LoggerFactory.getLogger((String)"[coffee4j]");
    private final ModelConverter modelConverter;

    public LoggingConflictDetectionReporter(ModelConverter modelConverter) {
        this.modelConverter = modelConverter;
    }

    @Override
    public void reportDetectedMissingInvalidTuples(List<MissingInvalidTuple> missingInvalidTuples) {
        this.logger.error("Conflicts among constraints detected!");
        this.logger.error("");
        for (MissingInvalidTuple missingInvalidTuple : missingInvalidTuples) {
            this.reportMissingInvalidTuple(missingInvalidTuple);
        }
        this.logger.error("Please repair the constraints and re-run the tests.");
        this.logger.error("");
    }

    @Override
    public void reportMinimalDiagnosisHittingSets(List<DiagnosisHittingSet> minimalDiagnosisHittingSets) {
        for (DiagnosisHittingSet set : minimalDiagnosisHittingSets) {
            this.reportMinimalDiagnosisHittingSet(set);
        }
        this.logger.error("");
    }

    private void reportMinimalDiagnosisHittingSet(DiagnosisHittingSet set) {
        this.logger.error("Relax the constraints as follows.");
        for (DiagnosisElement element : set.getDiagnosisElements()) {
            Combination combination = this.findCombination(element.getInvolvedParameters(), element.getConflictingValues());
            Constraint diagnosedConstraint = this.findConstraint(element.getDiagnosedConstraintId());
            this.logger.error("Remove {} from constraint {} with parameters {}.", new Object[]{combination, diagnosedConstraint.getName(), diagnosedConstraint.getParameterNames()});
        }
        this.logger.error("");
    }

    private void reportMissingInvalidTuple(MissingInvalidTuple missingInvalidTuple) {
        Combination combination = this.findCombination(missingInvalidTuple.getInvolvedParameters(), missingInvalidTuple.getMissingValues());
        Constraint negatedErrorConstraint = this.findConstraint(missingInvalidTuple.getNegatedErrorConstraintId());
        this.logger.error("For error-constraint {} with parameters {}, {} is missing.", new Object[]{negatedErrorConstraint.getName(), negatedErrorConstraint.getParameterNames(), combination});
        this.reportExplanation(missingInvalidTuple.getExplanation());
        this.logger.error("");
    }

    private void reportExplanation(ConflictExplanation explanation) {
        if (explanation instanceof UnknownConflictExplanation) {
            this.reportUnknownExplanation();
        } else if (explanation instanceof InconsistentBackground) {
            this.reportInconsistentBackground((InconsistentBackground)explanation);
        } else if (explanation instanceof ConflictSet) {
            this.reportConflictSet((ConflictSet)explanation);
        } else if (explanation instanceof DiagnosisSets) {
            this.reportConflictSet(((DiagnosisSets)explanation).getRootConflictSet());
        } else {
            throw new IllegalStateException();
        }
    }

    private void reportUnknownExplanation() {
        this.logger.error("For more information, enable conflict explanation and diagnosis.");
    }

    private void reportInconsistentBackground(InconsistentBackground explanation) {
        this.logger.error("\tThe constraint itself is incorrect. {}", (Object)explanation);
    }

    private void reportConflictSet(ConflictSet conflictSet) {
        this.logger.error("The interaction with the following constraint(s) is causing the absence:");
        for (ConflictElement element : conflictSet.getConflictElements()) {
            Combination combination = this.findCombination(element.getInvolvedParameters(), element.getConflictingValues());
            Constraint constraint = this.findConstraint(element.getConflictingConstraintId());
            this.logger.error("For constraint {} with parameters {}, {} causes the absence.", new Object[]{constraint.getName(), constraint.getParameterNames(), combination});
        }
    }

    private int[] convertTupleFromDualRepresentation(int[] parameters, int[] values) {
        int[] convertedTuple = new int[this.modelConverter.getConvertedModel().getParameterSizes().length];
        Arrays.fill(convertedTuple, -1);
        for (int i = 0; i < parameters.length; ++i) {
            int value;
            int parameter = parameters[i];
            convertedTuple[parameter] = value = values[i];
        }
        return convertedTuple;
    }

    private Combination findCombination(int[] parameters, int[] values) {
        int[] tuple = this.convertTupleFromDualRepresentation(parameters, values);
        return this.modelConverter.convertCombination(tuple);
    }

    private Constraint findConstraint(int id) {
        TupleList negatedTupleList = this.modelConverter.getConvertedModel().getErrorTupleLists().stream().filter(tupleList -> tupleList.getId() == id).findFirst().orElseThrow(() -> new IllegalStateException("unknown constraint with id " + id));
        return this.modelConverter.convertConstraint(negatedTupleList);
    }
}

