/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.report;

import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.conflict.ConflictSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisElement;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisHittingSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSet;
import de.rwth.swc.coffee4j.algorithmic.conflict.DiagnosisSets;
import de.rwth.swc.coffee4j.algorithmic.conflict.InconsistentBackground;
import de.rwth.swc.coffee4j.algorithmic.conflict.MissingInvalidTuple;
import de.rwth.swc.coffee4j.algorithmic.conflict.UnknownConflictExplanation;
import de.rwth.swc.coffee4j.algorithmic.model.TupleList;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.report.ConflictDetectionReporter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class PrintStreamConflictDetectionReporter
implements ConflictDetectionReporter {
    private final PrintStream printStream;
    private final ModelConverter modelConverter;

    public PrintStreamConflictDetectionReporter(PrintStream printStream, ModelConverter modelConverter) {
        Preconditions.notNull((Object)printStream);
        Preconditions.notNull((Object)modelConverter);
        this.printStream = printStream;
        this.modelConverter = modelConverter;
    }

    @Override
    public void reportDetectedMissingInvalidTuples(List<MissingInvalidTuple> missingInvalidTuples) {
        this.printStream.println("ERROR: Conflicts among constraints detected!");
        this.printStream.println("--------------------------------------------");
        this.printStream.println();
        for (MissingInvalidTuple missingInvalidTuple : missingInvalidTuples) {
            this.reportMissingInvalidTuple(missingInvalidTuple);
        }
        this.printStream.println("Please repair the constraints and re-run the tests.");
        this.printStream.println();
    }

    @Override
    public void reportMinimalDiagnosisHittingSets(List<DiagnosisHittingSet> minimalHittingSets) {
        this.printStream.println("ERROR: Conflicts among constraints detected!");
        this.printStream.println("--------------------------------------------");
        for (DiagnosisHittingSet set : minimalHittingSets) {
            this.reportMinimalDiagnosisHittingSet(set);
        }
        this.printStream.println("Please repair the constraints and re-run the tests.");
        this.printStream.println();
    }

    private void reportMinimalDiagnosisHittingSet(DiagnosisHittingSet set) {
        this.printStream.println("Relax the constraints as follows.");
        for (DiagnosisElement element : set.getDiagnosisElements()) {
            Combination combination = this.findCombination(element.getInvolvedParameters(), element.getConflictingValues());
            Constraint diagnosedConstraint = this.findConstraint(element.getDiagnosedConstraintId());
            this.printStream.println("\tRemove " + combination + " from " + diagnosedConstraint + ".");
        }
        this.printStream.println();
    }

    private void reportMissingInvalidTuple(MissingInvalidTuple missingInvalidTuple) {
        Combination combination = this.findCombination(missingInvalidTuple.getInvolvedParameters(), missingInvalidTuple.getMissingValues());
        Constraint negatedErrorConstraint = this.findConstraint(missingInvalidTuple.getNegatedErrorConstraintId());
        this.printStream.println("For error-constraint \n\t" + negatedErrorConstraint + ",\n\t" + combination + "\nis missing.");
        this.printStream.println();
        this.reportExplanation(missingInvalidTuple.getExplanation());
        this.printStream.println();
    }

    private void reportExplanation(ConflictExplanation explanation) {
        if (explanation instanceof UnknownConflictExplanation) {
            this.reportUnknownExplanation();
        } else if (explanation instanceof InconsistentBackground) {
            this.reportInconsistentBackground((InconsistentBackground)explanation);
        } else if (explanation instanceof ConflictSet) {
            this.reportConflictSet((ConflictSet)explanation);
        } else if (explanation instanceof DiagnosisSets) {
            this.reportDiagnosisSet((DiagnosisSets)explanation);
        } else {
            throw new IllegalStateException();
        }
    }

    private void reportUnknownExplanation() {
        this.printStream.println("For more information, enable conflict explanation and diagnosis.");
    }

    private void reportInconsistentBackground(InconsistentBackground explanation) {
        this.printStream.println("\tThe constraint itself is incorrect. " + explanation);
    }

    private void reportConflictSet(ConflictSet conflictSet) {
        this.printStream.println("The interaction with the following constraints is causing the absence:");
        for (ConflictElement element : conflictSet.getConflictElements()) {
            Combination combination = this.findCombination(element.getInvolvedParameters(), element.getConflictingValues());
            Constraint constraint = this.findConstraint(element.getConflictingConstraintId());
            this.printStream.println("\t" + constraint + " with " + combination);
        }
    }

    private void reportDiagnosisSet(DiagnosisSets diagnosisSets) {
        for (DiagnosisSet diagnosis : diagnosisSets.getDiagnosisSets()) {
            this.reportDiagnosis(diagnosis);
        }
    }

    private void reportDiagnosis(DiagnosisSet diagnosis) {
        this.printStream.println("As a diagnosis, relax ");
        for (DiagnosisElement element : diagnosis.getDiagnosisElements()) {
            Combination combination = this.findCombination(element.getInvolvedParameters(), element.getConflictingValues());
            Constraint constraint = this.findConstraint(element.getDiagnosedConstraintId());
            this.printStream.println("\t" + combination + " of " + constraint);
        }
        this.printStream.println("to remove all conflicts.");
    }

    private int[] convertTupleFromDualRepresentation(int[] parameters, int[] values) {
        int[] convertedTuple = new int[this.modelConverter.getConvertedModel().getParameterSizes().length];
        Arrays.fill(convertedTuple, -1);
        for (int i = 0; i < parameters.length; ++i) {
            int value;
            int parameter = parameters[i];
            convertedTuple[parameter] = value = values[i];
        }
        return convertedTuple;
    }

    private Combination findCombination(int[] parameters, int[] values) {
        int[] tuple = this.convertTupleFromDualRepresentation(parameters, values);
        return this.modelConverter.convertCombination(tuple);
    }

    private Constraint findConstraint(int id) {
        TupleList negatedTupleList = this.modelConverter.getConvertedModel().getErrorTupleLists().stream().filter(tupleList -> tupleList.getId() == id).findFirst().orElseThrow(() -> new IllegalStateException("unknown constraint with id " + id));
        return this.modelConverter.convertConstraint(negatedTupleList);
    }
}

