/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.process.report.sequential;

import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.report.Report;
import de.rwth.swc.coffee4j.algorithmic.report.ReportLevel;
import de.rwth.swc.coffee4j.algorithmic.sequential.characterization.FaultCharacterizationAlgorithm;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.TestInputGroupContext;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.constraints.Constraint;
import de.rwth.swc.coffee4j.engine.process.report.util.ReportUtility;
import de.rwth.swc.coffee4j.engine.report.SequentialExecutionReporter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSequentialExecutionReporter
implements SequentialExecutionReporter {
    protected final Logger logger;

    public LoggingSequentialExecutionReporter() {
        this(LoggerFactory.getLogger((String)"[coffee4j]"));
    }

    public LoggingSequentialExecutionReporter(Logger logger) {
        Preconditions.notNull((Object)logger);
        this.logger = logger;
    }

    @Override
    public void testInputGroupGenerated(TestInputGroupContext context, List<Combination> testInputs) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Generated test input group \"{}\".", (Object)this.identifierAsString(context));
        }
        if (testInputs != null) {
            for (Combination combination : testInputs) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(String.valueOf(combination));
            }
        }
    }

    private String identifierAsString(TestInputGroupContext context) {
        Object identifier = context.getIdentifier();
        if (identifier instanceof Constraint) {
            String generatorNameAsString = context.getGenerator().getClass().getSimpleName();
            return generatorNameAsString + " for Constraint " + ((Constraint)identifier).getName();
        }
        return identifier.toString();
    }

    @Override
    public void testInputGroupFinished(TestInputGroupContext context) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finished test input group \"{}\".", (Object)this.identifierAsString(context));
        }
    }

    @Override
    public void faultCharacterizationStarted(TestInputGroupContext context, FaultCharacterizationAlgorithm algorithm) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Started fault characterization for \"{}\".", (Object)this.identifierAsString(context));
        }
    }

    @Override
    public void faultCharacterizationFinished(TestInputGroupContext context, Map<Combination, Class<? extends Throwable>> exceptionInducingCombinations, Collection<Combination> failureInducingCombinations) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finished fault characterization for \"{}\".", (Object)this.identifierAsString(context));
        }
        this.printExceptionInducingCombinations(exceptionInducingCombinations);
        this.logger.info(ReportUtility.getFormattedFailureInducingCombinations(failureInducingCombinations));
        this.printWarning(failureInducingCombinations);
    }

    protected void printWarning(Collection<Combination> failureInducingCombinations) {
    }

    protected void printExceptionInducingCombinations(Map<Combination, Class<? extends Throwable>> exceptionInducingCombinations) {
    }

    @Override
    public void faultCharacterizationTestInputsGenerated(TestInputGroupContext context, List<Combination> testInputs) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Generated additional fault characterization test inputs for \"{}\".", (Object)this.identifierAsString(context));
        }
        if (testInputs != null) {
            for (Combination testInput : testInputs) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(String.valueOf(testInput));
            }
        }
    }

    @Override
    public void testInputExecutionStarted(Combination testInput) {
        this.logger.info("Started execution for test input {}.", (Object)testInput);
    }

    @Override
    public void testInputExecutionFinished(Combination testInput, TestResult result) {
        this.logger.info("Finished execution for test input {}: {}", (Object)testInput, (Object)result);
    }

    @Override
    public void report(ReportLevel level, Report report) {
        this.logger.info("Report with level {}: {}", (Object)level, (Object)report);
    }
}

