/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.report;

import de.rwth.swc.coffee4j.algorithmic.interleaving.InterleavingCombinatorialTestGroup;
import de.rwth.swc.coffee4j.algorithmic.model.TestResult;
import de.rwth.swc.coffee4j.algorithmic.report.Report;
import de.rwth.swc.coffee4j.algorithmic.report.ReportLevel;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.configuration.model.Combination;
import de.rwth.swc.coffee4j.engine.configuration.model.InputParameterModel;
import de.rwth.swc.coffee4j.engine.report.InterleavingExecutionReporter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.platform.commons.function.Try;

public class DelegatingInterleavingExecutionReporter
implements InterleavingExecutionReporter {
    private final Set<InterleavingExecutionReporter> executionReporters;

    public DelegatingInterleavingExecutionReporter(Collection<InterleavingExecutionReporter> reporters) {
        Preconditions.notNull(reporters);
        Preconditions.check((boolean)Try.call(() -> !reporters.contains(null)).toOptional().orElse(true));
        this.executionReporters = new HashSet<InterleavingExecutionReporter>(reporters);
    }

    @Override
    public void interleavingGroupGenerated(InterleavingCombinatorialTestGroup group) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.interleavingGroupGenerated(group);
        }
    }

    @Override
    public void interleavingGroupFinished(InterleavingCombinatorialTestGroup group, Map<Combination, Class<? extends Throwable>> exceptionInducingCombinations, Set<Combination> possibleFailureInducingCombinations) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.interleavingGroupFinished(group, exceptionInducingCombinations, possibleFailureInducingCombinations);
        }
    }

    @Override
    public void identificationStarted(InterleavingCombinatorialTestGroup group, Combination failingTestInput) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.identificationStarted(group, failingTestInput);
        }
    }

    @Override
    public void identificationFinished(InterleavingCombinatorialTestGroup group, Set<Combination> exceptionInducingCombinations, Set<Combination> failureInducingCombinations) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.identificationFinished(group, exceptionInducingCombinations, failureInducingCombinations);
        }
    }

    @Override
    public void identificationTestInputGenerated(InterleavingCombinatorialTestGroup group, Combination testInput) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.identificationTestInputGenerated(group, testInput);
        }
    }

    @Override
    public void checkingStarted(InterleavingCombinatorialTestGroup group, Combination failureInducingCombination) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.checkingStarted(group, failureInducingCombination);
        }
    }

    @Override
    public void checkingFinished(InterleavingCombinatorialTestGroup group, Combination failureInducingCombination, boolean isFailureInducing) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.checkingFinished(group, failureInducingCombination, isFailureInducing);
        }
    }

    @Override
    public void testInputExecutionStarted(Combination testInput) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.testInputExecutionStarted(testInput);
        }
    }

    @Override
    public void testInputExecutionFinished(Combination testInput, TestResult result) {
        for (InterleavingExecutionReporter reporter : this.executionReporters) {
            reporter.testInputExecutionFinished(testInput, result);
        }
    }

    @Override
    public ReportLevel getReportLevel() {
        ReportLevel leastWorstLevel = ReportLevel.FATAL;
        for (InterleavingExecutionReporter executionReporter : this.executionReporters) {
            if (executionReporter.getReportLevel().isWorseThanOrEqualTo(leastWorstLevel)) continue;
            leastWorstLevel = executionReporter.getReportLevel();
        }
        return leastWorstLevel;
    }

    @Override
    public void report(ReportLevel level, Report report) {
        Preconditions.notNull((Object)level);
        for (InterleavingExecutionReporter executionReporter : this.executionReporters) {
            if (!level.isWorseThanOrEqualTo(executionReporter.getReportLevel())) continue;
            executionReporter.report(level, new Report(report));
        }
    }

    @Override
    public void modelModified(InputParameterModel original, InputParameterModel modified) {
        for (InterleavingExecutionReporter executionReporter : this.executionReporters) {
            executionReporter.modelModified(original, modified);
        }
    }
}

