/*
 * Decompiled with CFR 0.152.
 */
package de.rwth.swc.coffee4j.engine.report;

import de.rwth.swc.coffee4j.algorithmic.report.ArgumentConverter;
import de.rwth.swc.coffee4j.algorithmic.util.Preconditions;
import de.rwth.swc.coffee4j.engine.converter.model.ModelConverter;
import de.rwth.swc.coffee4j.engine.report.ModelBasedArgumentConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.platform.commons.function.Try;

public class DelegatingModelBasedArgumentConverter
extends ModelBasedArgumentConverter {
    private final List<ArgumentConverter> argumentConverters;

    public DelegatingModelBasedArgumentConverter(Collection<ArgumentConverter> argumentConverters) {
        Preconditions.notNull(argumentConverters);
        Preconditions.check((boolean)Try.call(() -> !argumentConverters.contains(null)).toOptional().orElse(true));
        this.argumentConverters = new ArrayList<ArgumentConverter>(argumentConverters);
    }

    @Override
    public void initialize(ModelConverter modelConverter) {
        for (ArgumentConverter argumentConverter : this.argumentConverters) {
            if (!(argumentConverter instanceof ModelBasedArgumentConverter)) continue;
            ((ModelBasedArgumentConverter)argumentConverter).initialize(modelConverter);
        }
    }

    public boolean canConvert(Object argument) {
        for (ArgumentConverter argumentConverter : this.argumentConverters) {
            if (!argumentConverter.canConvert(argument)) continue;
            return true;
        }
        return false;
    }

    public Object convert(Object argument) {
        for (ArgumentConverter argumentConverter : this.argumentConverters) {
            if (!argumentConverter.canConvert(argument)) continue;
            return argumentConverter.convert(argument);
        }
        throw new IllegalStateException("This method should not be called if canConcert returns false");
    }
}

