/*
 * Decompiled with CFR 0.152.
 */
package de.saly.javamail.mock2;

import de.saly.javamail.mock2.MailboxFolder;
import java.util.Date;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMessage
extends MimeMessage
implements Comparable<MockMessage> {
    private final FlagChangeListener flagChangeListener;
    private Folder folder;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MailboxFolder mbf;
    private final long mockid;

    protected MockMessage(Message source, Folder folder) throws MessagingException {
        this((MimeMessage)source, ((MockMessage)source).mockid, ((MockMessage)source).mbf, ((MockMessage)source).flagChangeListener);
        this.folder = folder;
        this.setMessageNumber(source.getMessageNumber());
    }

    protected MockMessage(MimeMessage source, long mockid, MailboxFolder mbf, FlagChangeListener flagChangeListener) throws MessagingException {
        super(source);
        this.mockid = mockid;
        this.flagChangeListener = flagChangeListener;
        this.mbf = mbf;
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void addHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void addHeaderLine(String line) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void addRecipient(Message.RecipientType type, Address address) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void addRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    @Override
    public int compareTo(MockMessage o) {
        return new Long(this.getMockid()).compareTo(new Long(o.getMockid()));
    }

    public synchronized Folder getFolder() {
        if (this.folder == null) {
            throw new RuntimeException("wrong/unshaded mock message");
        }
        return this.folder;
    }

    public long getMockid() {
        return this.mockid;
    }

    public void removeHeader(String name) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void saveChanges() throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setContent(Multipart mp) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setContent(Object o, String type) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setContentID(String cid) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setContentMD5(String md5) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setDataHandler(DataHandler content) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setDescription(String description) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setDescription(String description, String charset) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setDisposition(String disposition) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    protected void setExpunged(boolean expunged) {
        super.setExpunged(expunged);
    }

    public void setFileName(String filename) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public synchronized void setFlags(Flags flag, boolean set) throws MessagingException {
        super.setFlags(flag, set);
        if (this.flagChangeListener != null) {
            this.flagChangeListener.onFlagChange(this, flag, set);
        }
    }

    public void setFrom() throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setFrom(Address address) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setFrom(String address) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    protected void setMessageNumber(int msgnum) {
        super.setMessageNumber(msgnum);
    }

    public void setRecipient(Message.RecipientType type, Address address) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setSender(Address address) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setSentDate(Date d) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    void setSpecialHeader(String name, String value) throws MessagingException {
        super.addHeader(name, value);
    }

    public void setSubject(String subject) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setSubject(String subject, String charset) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setText(String text) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setText(String text, String charset) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public void setText(String text, String charset, String subtype) throws MessagingException {
        throw new IllegalWriteException("Mock messages are read-only");
    }

    public static interface FlagChangeListener {
        public void onFlagChange(MockMessage var1, Flags var2, boolean var3);
    }
}

