package de.sambalmueslie.herold.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import de.sambalmueslie.herold.DataModelElement;

/**
 * If you use separate interface and implementation, this annotations tells the implementation type.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ImplementationType {
	Class<? extends DataModelElement> value();
}
