/*
 * Decompiled with CFR 0.152.
 */
package de.sambalmueslie.herold.model;

import de.sambalmueslie.herold.DataModel;
import de.sambalmueslie.herold.DataModelElement;
import de.sambalmueslie.herold.HeroldDataCenter;
import de.sambalmueslie.herold.annotations.ImplementationType;
import de.sambalmueslie.herold.model.Metadata;
import de.sambalmueslie.herold.model.ModelController;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DataCenter
implements HeroldDataCenter {
    private static Logger logger = LogManager.getLogger(DataCenter.class);
    private final String globalOperatorId;
    private final Map<Class<?>, Metadata<?>> metadataCache = new HashMap();
    private final Map<Class<?>, ModelController<?>> models = new LinkedHashMap();

    public DataCenter(String operatorId) {
        this.globalOperatorId = operatorId;
    }

    @Override
    public <T extends DataModelElement> Optional<DataModel<T>> createModel(Class<T> elementType) {
        return this.createModel(elementType, this.globalOperatorId);
    }

    @Override
    public <T extends DataModelElement> Optional<DataModel<T>> createModel(Class<T> elementType, String operatorId) {
        logger.debug("Create new model of type {} for operator {}", elementType, (Object)operatorId);
        Metadata<T> metadata = this.getMetadata(elementType);
        if (!this.isValid(metadata)) {
            logger.error("Cannot create model of invalid type {}", elementType);
            return Optional.empty();
        }
        ModelController<T> controller = this.getController(metadata);
        return controller.createNewInstance(operatorId);
    }

    @Override
    public void removeAllModel() {
        logger.debug("Remove all models");
        this.models.values().forEach(ModelController::dispose);
        this.models.clear();
        this.metadataCache.clear();
    }

    @Override
    public <T extends DataModelElement> void removeAllModel(Class<T> elementType) {
        if (!this.models.containsKey(elementType)) {
            return;
        }
        logger.debug("Create remove all model of type {}", elementType);
        Metadata<T> metadata = this.getMetadata(elementType);
        ModelController<T> controller = this.getController(metadata);
        controller.removeAll();
        controller.dispose();
        this.models.remove(metadata.getElementImplType());
        this.metadataCache.remove(elementType);
    }

    @Override
    public <T extends DataModelElement> void removeModel(Class<T> elementType, DataModel<T> model) {
        if (!this.models.containsKey(elementType)) {
            return;
        }
        logger.debug("Create remove model of type {}", elementType);
        Metadata<T> metadata = this.getMetadata(elementType);
        ModelController<T> controller = this.getController(metadata);
        controller.remove(model);
        if (controller.isUnused()) {
            controller.dispose();
            this.models.remove(metadata.getElementImplType());
            this.metadataCache.remove(elementType);
        }
    }

    private <T extends DataModelElement> ModelController<T> getController(Metadata<T> metadata) {
        Class<T> implType = metadata.getElementImplType();
        ModelController<Object> controller = this.models.get(implType);
        if (controller == null) {
            controller = new ModelController<T>(metadata);
            this.models.put(implType, controller);
        }
        return controller;
    }

    private <T extends DataModelElement> Metadata<T> getMetadata(Class<T> elementType) {
        if (this.metadataCache.containsKey(elementType)) {
            return this.metadataCache.get(elementType);
        }
        Metadata<T> metadata = new Metadata<T>(elementType);
        this.metadataCache.put(elementType, metadata);
        return metadata;
    }

    private <T extends DataModelElement> boolean isValid(Metadata<T> metadata) {
        Class<T> elementType = metadata.getElementType();
        Class<T> implType = metadata.getElementImplType();
        if (implType.isInterface()) {
            logger.error("Element type {} must define annotation {} or be an instanceable type.", elementType, ImplementationType.class);
            return false;
        }
        try {
            if (implType.getConstructor(new Class[0]) == null) {
                logger.error("Element type {} must define default constructor.", elementType);
                return false;
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.error("Element type {} must define accesible default constructor.", elementType);
            return false;
        }
        if (!elementType.isAssignableFrom(implType)) {
            logger.error("Implementation type {} must implement {}.", implType, elementType);
            return false;
        }
        if (!DataModelElement.class.isAssignableFrom(implType)) {
            logger.error("Element type {} must implement {}.", elementType, DataModelElement.class);
            return false;
        }
        return true;
    }
}

